/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.stygian_end;

import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import io.netty.util.internal.IntegerHolder;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerStygianEndCascadingFix
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "fluke.stygian.world.feature.WorldGenEnderCanopy": {
                return NetherAPIConfig.StygianEnd.wideEnderCanopyGen ? basicClass : this.transform(basicClass, classNode -> {
                    block19: for (MethodNode method : classNode.methods) {
                        block8 : switch (method.name) {
                            case "isValidGenLocation": {
                                int n;
                                int trunkRadiusVar = this.getLocalVar(method, "trunkRadius");
                                int canopyRadiusVar = this.getLocalVar(method, "canopyRadius");
                                AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
                                int n2 = abstractInsnNodeArray.length;
                                for (n = 0; n < n2; ++n) {
                                    AbstractInsnNode insn = abstractInsnNodeArray[n];
                                    if (insn.getOpcode() == 16) {
                                        if (((IntInsnNode)insn).operand == -23) {
                                            ((IntInsnNode)insn).operand = -15;
                                            continue;
                                        }
                                        if (((IntInsnNode)insn).operand != 23) continue;
                                        ((IntInsnNode)insn).operand = 15;
                                        continue;
                                    }
                                    if (insn.getOpcode() == 17 && ((IntInsnNode)insn).operand == 529) {
                                        ((IntInsnNode)insn).operand = 225;
                                        continue;
                                    }
                                    if (insn.getOpcode() != 54 || ((VarInsnNode)insn).var != trunkRadiusVar && ((VarInsnNode)insn).var != canopyRadiusVar) continue;
                                    method.instructions.remove(insn.getPrevious());
                                    method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(2));
                                }
                                continue block19;
                            }
                            case "buildCanopy": {
                                int n;
                                AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
                                int n3 = abstractInsnNodeArray.length;
                                for (n = 0; n < n3; ++n) {
                                    AbstractInsnNode insn = abstractInsnNodeArray[n];
                                    if (insn.getOpcode() != 16 || ((IntInsnNode)insn).operand != 8) continue;
                                    ((IntInsnNode)insn).operand = 7;
                                    break block8;
                                }
                                continue block19;
                            }
                            case "buildTrunk": {
                                int n;
                                AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
                                int n4 = abstractInsnNodeArray.length;
                                for (n = 0; n < n4; ++n) {
                                    AbstractInsnNode insn = abstractInsnNodeArray[n];
                                    if (insn.getOpcode() != 16 || ((IntInsnNode)insn).operand != 18) continue;
                                    ((IntInsnNode)insn).operand = 15;
                                }
                                continue block19;
                            }
                            case "buildBranches": {
                                AbstractInsnNode insn;
                                int branchLengthVar = this.getLocalVar(method, "branchLength");
                                if (branchLengthVar == -1) {
                                    throw new UnsupportedOperationException("Unsupported version of Stygian End found, please try a different version!");
                                }
                                AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
                                int n = abstractInsnNodeArray.length;
                                for (int i = 0; i < n; ++i) {
                                    insn = abstractInsnNodeArray[i];
                                    if (insn.getOpcode() == 54 && ((VarInsnNode)insn).var == branchLengthVar) {
                                        AbstractInsnNode nextBackInsn = insn.getPrevious();
                                        int maxChanges = 2;
                                        while (maxChanges > 0) {
                                            AbstractInsnNode backInsn = nextBackInsn;
                                            nextBackInsn = backInsn.getPrevious();
                                            if (backInsn instanceof IntInsnNode) {
                                                --maxChanges;
                                                switch (((IntInsnNode)backInsn).operand) {
                                                    case 8: 
                                                    case 9: 
                                                    case 14: {
                                                        method.instructions.insert(backInsn, (AbstractInsnNode)new InsnNode(7));
                                                        method.instructions.remove(backInsn);
                                                        break;
                                                    }
                                                    case 7: {
                                                        method.instructions.insert(backInsn, (AbstractInsnNode)new InsnNode(6));
                                                        method.instructions.remove(backInsn);
                                                    }
                                                }
                                                continue;
                                            }
                                            if (backInsn.getOpcode() != 8) continue;
                                            --maxChanges;
                                            method.instructions.insert(backInsn, (AbstractInsnNode)new InsnNode(5));
                                            method.instructions.remove(backInsn);
                                        }
                                        continue;
                                    }
                                    if (insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals("isValidGenLocation")) continue;
                                    method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(4));
                                    method.instructions.remove(insn.getPrevious());
                                    method.instructions.remove(insn.getPrevious());
                                    method.instructions.remove(insn.getPrevious());
                                    method.instructions.remove(insn.getPrevious());
                                    method.instructions.remove(insn);
                                }
                                continue block19;
                            }
                            case "placeLogAt": 
                            case "placeLeafAt": {
                                AbstractInsnNode insn;
                                AbstractInsnNode[] abstractInsnNodeArray = method.instructions.toArray();
                                int n = abstractInsnNodeArray.length;
                                for (int i = 0; i < n; ++i) {
                                    insn = abstractInsnNodeArray[i];
                                    if (insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) continue;
                                    method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                                    if (!DEOBFUSCATED) {
                                        ((MethodInsnNode)insn).name = "func_180501_a";
                                    }
                                    ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                                    break block8;
                                }
                                break;
                            }
                        }
                    }
                });
            }
            case "fluke.stygian.world.feature.WorldGenEndVolcano": {
                IntegerHolder changes = new IntegerHolder();
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "generate" : "func_180709_b"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 6) {
                        method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(8));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                        if (!DEOBFUSCATED) {
                            ((MethodInsnNode)insn).name = "func_180501_a";
                        }
                        ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                        if (++changes.value == 2) {
                            return ITransformer.BreakType.METHODS;
                        }
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "fluke.stygian.world.biomes.BiomeEndVolcano": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "decorate" : "func_180624_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 1) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(178, "fluke/stygian/world/biomes/BiomeEndVolcano", "END_OBSIDIAN", "Lnet/minecraft/block/state/IBlockState;"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                        if (!DEOBFUSCATED) {
                            ((MethodInsnNode)insn).name = "func_180501_a";
                        }
                        ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }
}

