/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import com.mojang.authlib.GameProfile;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.world.PlayerSpawnLogic;
import io.netty.util.internal.IntegerHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.translation.I18n;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerNetHandlerPlayClient
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.client.network.NetHandlerPlayClient": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "handleJoinGame" : "func_147282_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getDimension" : "func_149194_f")) {
                        method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/WorldProvider", "getDimension", "()I", false));
                        method.instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", DEOBFUSCATED ? "provider" : "field_73011_w", "Lnet/minecraft/world/WorldProvider;"));
                        method.instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/network/NetHandlerPlayClient", DEOBFUSCATED ? "world" : "field_147300_g", "Lnet/minecraft/client/multiplayer/WorldClient;"));
                        method.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.entity.player.EntityPlayer": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("getSpawnDimension"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 3) {
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("getSpawnDim", "(ILcom/mojang/authlib/GameProfile;)I"));
                        method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/player/EntityPlayer", DEOBFUSCATED ? "getGameProfile" : "func_146103_bH", "()Lcom/mojang/authlib/GameProfile;", false));
                        method.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.server.management.PlayerList": 
            case "net.minecraft.server.MinecraftServer": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "createPlayerForUser" : "func_148545_a") || method.name.equals(DEOBFUSCATED ? "initialWorldChunkLoad" : "func_71222_d"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn instanceof MethodInsnNode && (((MethodInsnNode)insn).name.equals("getWorld") || ((MethodInsnNode)insn).name.equals("func_71218_a"))) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)("net.minecraft.server.management.PlayerList".equals(transformedName) ? new VarInsnNode(25, 1) : new InsnNode(1)));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getSpawnDim", "(ILcom/mojang/authlib/GameProfile;)I"));
                    } else if (insn instanceof LdcInsnNode && ((LdcInsnNode)insn).cst.equals("Preparing start region for level 0")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getStartingRegionString", "()Ljava/lang/String;"));
                        method.instructions.remove(insn);
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraftforge.fml.common.network.handshake.NetworkDispatcher": {
                IntegerHolder index = new IntegerHolder();
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("serverInitiateHandshake"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 172 && ++index.value == 2) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/fml/common/network/handshake/NetworkDispatcher", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;"));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/entity/player/EntityPlayer", DEOBFUSCATED ? "getGameProfile" : "func_146103_bH", "()Lcom/mojang/authlib/GameProfile;", false));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getSpawnDim", "(ILcom/mojang/authlib/GameProfile;)I"));
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        public static int getSpawnDim(int fallback, @Nullable GameProfile profile) {
            return PlayerSpawnLogic.getInitialSpawnDimension(profile);
        }

        @Nonnull
        public static String getStartingRegionString() {
            return I18n.func_74837_a((String)"info.nether_api.loadStartRegion", (Object[])new Object[]{Hooks.getSpawnDim(0, null)});
        }
    }
}

