/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.api.biome.IAmbienceBiome;
import git.jbredwards.nether_api.api.world.IAmbienceWorldProvider;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerWorldClient
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        return this.transform(basicClass, classNode -> {
            classNode.methods.removeIf(method -> method.name.equals(DEOBFUSCATED ? "playMoodSoundAndCheckLight" : "func_147467_a"));
            this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "showBarrierParticles" : "func_184153_a"), (MethodNode method, AbstractInsnNode insn) -> {
                if (insn.getOpcode() == 177) {
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 5));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 7));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 11));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnBiomeAmbientParticle", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V"));
                    return ITransformer.BreakType.METHODS;
                }
                return ITransformer.BreakType.CONTINUE;
            });
        });
    }

    public static final class Hooks {
        @SideOnly(value=Side.CLIENT)
        public static void spawnBiomeAmbientParticle(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2 && !state.func_185917_h()) {
                IParticleFactory[] factories = IAmbienceWorldProvider.getAmbienceOrFallback(world, pos, world.func_180494_b(pos), IParticleFactory[].class, IAmbienceWorldProvider::getAmbientParticles, IAmbienceBiome::getAmbientParticles, null);
                if (factories == null || factories.length == 0) {
                    return;
                }
                if (factories.length != 1) {
                    Collections.shuffle(Arrays.asList(factories), rand);
                }
                for (IParticleFactory factory : factories) {
                    Particle particle = factory.func_178902_a(-1, world, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    if (particle == null) continue;
                    if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 || rand.nextInt(3) != 0) {
                        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
                    }
                    return;
                }
            }
        }
    }
}

