/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.network.MessageTeleportFX;
import io.netty.util.internal.IntegerHolder;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Transformer_MC_10369
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.block.BlockLiquid": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "triggerMixEffects" : "func_180688_d"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 8) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 5));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 7));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnFluidParticles", "(Lnet/minecraft/world/World;DDD)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.block.BlockPumpkin": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "trySpawnGolem" : "func_180673_e"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_180501_a")) {
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("destroyBlockWithFlags", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 17 && ((IntInsnNode)insn).operand == 128) {
                        ((IntInsnNode)insn).operand = 0;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.block.BlockRedstoneTorch": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "updateTick" : "func_180650_b"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 8) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnTorchParticles", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.block.BlockSkull": {
                IntegerHolder index = new IntegerHolder();
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "checkWitherSpawn" : "func_180679_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_180501_a") && ++index.value == 2) {
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("destroyBlockWithFlags", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 128) {
                        ((IntInsnNode)insn).operand = 0;
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.entity.ai.EntityAIMate": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "spawnBaby" : "func_75388_i"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 7) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", DEOBFUSCATED ? "world" : "field_75394_a", "Lnet/minecraft/world/World;"));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", DEOBFUSCATED ? "animal" : "field_75390_d", "Lnet/minecraft/entity/passive/EntityAnimal;"));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnBabyParticles", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.entity.boss.EntityDragon": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "destroyBlocksInAABB" : "func_70972_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "spawnParticle" : "func_175688_a")) {
                        method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("spawnDragonParticle", "(Lnet/minecraft/world/World;Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.entity.EntityLivingBase": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "attemptTeleport" : "func_184595_k"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 17 && insn.getNext().getOpcode() != 54 && ((IntInsnNode)insn).operand == 128) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 7));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 9));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(24, 11));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnTeleportParticles", "(Lnet/minecraft/entity/Entity;DDD)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.item.ItemEnderEye": {
                return this.transformMethod(basicClass, true, method -> method.name.equals(DEOBFUSCATED ? "onItemUse" : "func_180614_a"), (method, insn) -> {
                    if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 16) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("spawnEyeParticles", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)I"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        public static boolean BABY_FIX = true;
        public static boolean DRAGON_FIX = true;
        public static boolean EYE_FIX = true;
        public static boolean FLUID_FIX = true;
        public static boolean GOLEM_FIX = true;
        public static boolean TELEPORT_FIX = true;
        public static boolean TORCH_FIX = true;

        public static boolean destroyBlockWithFlags(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState replaceState, int flags) {
            if (GOLEM_FIX) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)world.func_180495_p(pos)));
            }
            return world.func_180501_a(pos, replaceState, flags);
        }

        public static int spawnBabyParticles(@Nonnull World world, @Nonnull Entity animal) {
            if (BABY_FIX) {
                world.func_72960_a(animal, (byte)18);
            }
            return 0;
        }

        public static void spawnDragonParticle(@Nonnull World world, @Nonnull EnumParticleTypes particle, double x, double y, double z, double motionX, double motionY, double motionZ, int[] args) {
            if (DRAGON_FIX && world instanceof WorldServer) {
                ((WorldServer)world).func_180505_a(particle, true, x, y, z, 0, motionX, motionY, motionZ, 1.0, args);
            }
        }

        public static int spawnEyeParticles(@Nonnull World world, @Nonnull BlockPos pos) {
            if (EYE_FIX && world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.8125, (double)pos.func_177952_p() + 0.5, 16, 0.1875, 0.0, 0.1875, 0.0, new int[0]);
            }
            return 0;
        }

        public static int spawnFluidParticles(@Nonnull World world, double x, double y, double z) {
            if (FLUID_FIX && world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, x + 0.5, y + 1.2, z + 0.5, 8, 0.25, 0.0, 0.25, 0.0, new int[0]);
            }
            return 0;
        }

        public static int spawnTeleportParticles(@Nonnull Entity entity, double prevX, double prevY, double prevZ) {
            if (TELEPORT_FIX && entity.field_70170_p instanceof WorldServer) {
                MessageTeleportFX message = new MessageTeleportFX(entity, prevX, prevY, prevZ);
                if (entity instanceof EntityPlayerMP) {
                    NetherAPI.WRAPPER.sendTo((IMessage)message, (EntityPlayerMP)entity);
                }
                NetherAPI.WRAPPER.sendToAllTracking((IMessage)message, entity);
            }
            return 0;
        }

        public static int spawnTorchParticles(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (TORCH_FIX && world instanceof WorldServer) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
                double offsetX = 0.5;
                double offsetY = 0.5625;
                double offsetZ = 0.5;
                if (facing.func_176740_k().func_176722_c()) {
                    offsetX -= 0.27 * (double)facing.func_82601_c();
                    offsetY += 0.22;
                    offsetZ -= 0.27 * (double)facing.func_82599_e();
                }
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + offsetX, (double)pos.func_177956_o() + offsetY, (double)pos.func_177952_p() + offsetZ, 5, 0.1, 0.1, 0.1, 0.0, new int[0]);
            }
            return 0;
        }
    }
}

