/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.client.config;

import com.google.common.collect.Lists;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.client.config.GuiConfigTranslucent;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;

public final class NetherAPIGuiFactory
implements IModGuiFactory {
    @Nonnull
    private final Set<Class<?>> activeModCategories = new HashSet();

    public boolean hasConfigGui() {
        return true;
    }

    public void initialize(@Nonnull Minecraft minecraftInstance) {
        if (NetherAPI.isBetterNetherLoaded) {
            this.activeModCategories.add(NetherAPIConfig.BetterNether.class);
        }
        if (NetherAPI.isBiomesOPlentyLoaded) {
            this.activeModCategories.add(NetherAPIConfig.BOP.class);
        }
        if (NetherAPI.isJourneyIntoTheLightLoaded) {
            this.activeModCategories.add(NetherAPIConfig.JITL.class);
        }
        if (NetherAPI.isNethercraftLoaded) {
            this.activeModCategories.add(NetherAPIConfig.Nethercraft.class);
        }
        if (NetherAPI.isNetherHexedKingdomLoaded) {
            this.activeModCategories.add(NetherAPIConfig.NHK.class);
        }
        if (NetherAPI.isStygianEndLoaded) {
            this.activeModCategories.add(NetherAPIConfig.StygianEnd.class);
        }
    }

    @Nonnull
    public GuiScreen createConfigGui(@Nonnull GuiScreen parentScreen) {
        List<IConfigElement> elements = NetherAPIGuiFactory.sorted(Lists.newArrayList((Object[])new IConfigElement[]{new DummyConfigElement.DummyCategoryElement("nether_api/compat (dummy category)", "configgui.nether_api.compat", NetherAPIGuiFactory.sorted(this.activeModCategories.stream().map(ConfigElement::from).collect(Collectors.toList()))), new DummyConfigElement.DummyCategoryElement("nether_api/vanilla", "nether_api/vanilla", NetherAPIGuiFactory.sorted(ConfigElement.from(NetherAPIConfig.class).getChildElements()))}));
        if (this.activeModCategories.isEmpty()) {
            elements.addAll(elements.get(1).getChildElements());
            elements.remove(0);
            elements.remove(0);
        }
        return new GuiConfigTranslucent(parentScreen, elements, "nether_api", false, false, I18n.func_135052_a((String)"configgui.nether_api.title", (Object[])new Object[0]), null);
    }

    @Nonnull
    private static List<IConfigElement> sorted(@Nonnull List<IConfigElement> elements) {
        elements.sort(Comparator.comparing(element -> I18n.func_135052_a((String)element.getLanguageKey(), (Object[])new Object[0])));
        return elements;
    }

    @Nullable
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }
}

