/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.betternether;

import git.jbredwards.nether_api.api.biome.INetherAPIBiomeProvider;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistryListener;
import git.jbredwards.nether_api.mod.common.compat.betternether.BetterNetherHandler;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHell;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import paulevs.betternether.biomes.NetherBiome;

public final class BiomeBetterNether
extends BiomeHell
implements INetherAPIBiomeProvider,
INetherAPIRegistryListener {
    @Nonnull
    static final Field SUBBIOMES_FIELD = ObfuscationReflectionHelper.findField(NetherBiome.class, (String)"subbiomes");
    int cachedWeight = -1;
    @Nonnull
    public final NetherBiome netherBiome;
    public final int netherBiomeId;

    BiomeBetterNether(@Nonnull NetherBiome netherBiomeIn, int netherBiomeIdIn) {
        super(new Biome.BiomeProperties(netherBiomeIn.getName()).func_185410_a(2.0f).func_185395_b(0.0f).func_185396_a());
        this.setRegistryName("nether_api", "betternether_" + netherBiomeIn.getClass().getSimpleName());
        this.netherBiome = netherBiomeIn;
        this.netherBiomeId = netherBiomeIdIn;
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getSubBiomes() {
        List<NetherBiome> subBiomes = BiomeBetterNether.getSubNetherBiomes(this.netherBiome);
        if (subBiomes.isEmpty() || subBiomes.size() == 1 && subBiomes.get(0) == this.netherBiome) {
            return Collections.emptyList();
        }
        return subBiomes.stream().filter(netherBiomeIn -> BetterNetherHandler.getWeight(BetterNetherHandler.getBiomeFromLookup(netherBiomeIn)) > 0).map(netherBiomeIn -> netherBiomeIn == this.netherBiome ? new BiomeManager.BiomeEntry((Biome)this, 1000) : BetterNetherHandler.getBiomeFromLookup(netherBiomeIn).createBiomeEntry()).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getEdgeBiomes(int neighborBiomeId) {
        NetherBiome edge = this.netherBiome.getEdge();
        if (edge == this.netherBiome) {
            return Collections.emptyList();
        }
        Biome neighborBiome = Biome.func_185357_a((int)neighborBiomeId);
        if (neighborBiome == this) {
            return Collections.emptyList();
        }
        for (BiomeManager.BiomeEntry entry : this.getSubBiomes()) {
            if (entry.biome != neighborBiome) continue;
            return Collections.emptyList();
        }
        return Collections.singletonList(BetterNetherHandler.getBiomeFromLookup(edge).createBiomeEntry());
    }

    @Nonnull
    public static List<NetherBiome> getSubNetherBiomes(@Nonnull NetherBiome netherBiome) {
        try {
            return (List)SUBBIOMES_FIELD.get(netherBiome);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onAddedToRegistry(@Nonnull INetherAPIRegistry registry, @Nonnull OptionalInt newWeight) {
        if (newWeight.isPresent()) {
            this.cachedWeight = newWeight.getAsInt();
        }
    }

    @Override
    public void onRemovedFromRegistry(@Nonnull INetherAPIRegistry registry, @Nonnull OptionalInt oldWeight) {
        this.cachedWeight = -1;
    }

    @Nonnull
    public BiomeManager.BiomeEntry createBiomeEntry() {
        return new BiomeManager.BiomeEntry((Biome)this, BetterNetherHandler.getWeight(this));
    }
}

