/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.block.BlockColoring;
import biomesoplenty.common.world.WorldTypeBOP;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.util.PlantUtils;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class BiomesOPlentyHandler {
    public static boolean allowBOPNetherBiomes(@Nonnull World world) {
        return !NetherAPIConfig.BOP.dependentBOPHellBiomes || world.func_175624_G() instanceof WorldTypeBOP;
    }

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry, @Nonnull World world) {
        if (BiomesOPlentyHandler.allowBOPNetherBiomes(world)) {
            BOPBiomes.REG_INSTANCE.getPresentBiomes().forEach(biome -> {
                IExtendedBiome extended = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
                if (extended != null) {
                    registry.registerBiome((Biome)biome, extended.getWeightMap().getOrDefault(BOPClimates.HELL, 0));
                }
            });
        }
    }

    private static boolean canSurvive(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumPlantType type) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().canSustainPlant(state, world, pos, EnumFacing.UP, PlantUtils.createPlantable(type));
    }

    public static void init() {
        IBlockPosQuery fertileOrNetherrack = BlockQueries.fertileOrNetherrack;
        BlockQueries.fertileOrNetherrack = (world, pos) -> fertileOrNetherrack.matches(world, pos) || BiomesOPlentyHandler.canSurvive((IBlockAccess)world, pos, PlantUtils.NETHERRACK_PLANT_TYPE);
        IBlockPosQuery sustainsNether = BlockQueries.sustainsNether;
        BlockQueries.sustainsNether = (world, pos) -> sustainsNether.matches(world, pos) || BiomesOPlentyHandler.canSurvive((IBlockAccess)world, pos, PlantUtils.SOUL_SAND_PLANT_TYPE);
        IBlockPosQuery endish = BlockQueries.endish;
        BlockQueries.endish = (world, pos) -> endish.matches(world, pos) || BiomesOPlentyHandler.canSurvive((IBlockAccess)world, pos, PlantUtils.END_PLANT_TYPE);
        IBlockPosQuery hellish = BlockQueries.hellish;
        BlockQueries.hellish = (world, pos) -> hellish.matches(world, pos) || BiomesOPlentyHandler.canSurvive((IBlockAccess)world, pos, PlantUtils.NETHERRACK_PLANT_TYPE);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> tintIndex == 0 && MinecraftForgeClient.getRenderLayer() == null ? -1 : BlockColoring.GRASS_COLORING.func_186720_a(state, world, pos, tintIndex), new Block[]{BOPBlocks.grass});
    }
}

