/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.google.common.collect.ImmutableList;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootyEndStone;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootyNetherrack;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootySoulSand;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DynamicTreesHandler {
    @SubscribeEvent
    static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockRootyEndStone.INSTANCE, BlockRootyNetherrack.INSTANCE, BlockRootySoulSand.INSTANCE});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void registerColors(@Nonnull ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            if (tintIndex == 1) {
                return ((BlockRooty)state.func_177230_c()).rootColor(state, world, pos);
            }
            IBlockState mimic = ((BlockRooty)state.func_177230_c()).getMimic(world, pos);
            return event.getBlockColors().func_186724_a(mimic, world, pos, Math.max(0, tintIndex - 2));
        }, new Block[]{BlockRootyEndStone.INSTANCE, BlockRootyNetherrack.INSTANCE, BlockRootySoulSand.INSTANCE});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void registerMappers(@Nonnull ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)BlockRootyEndStone.INSTANCE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockRootyNetherrack.INSTANCE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockRootySoulSand.INSTANCE, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRooty.LIFE}).func_178441_a());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    static void registerModels(@Nonnull ModelBakeEvent event) {
        DynamicTreesHandler.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), event.getModelManager().func_174954_c(), BlockRootyEndStone.INSTANCE);
        DynamicTreesHandler.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), event.getModelManager().func_174954_c(), BlockRootyNetherrack.INSTANCE);
        DynamicTreesHandler.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), event.getModelManager().func_174954_c(), BlockRootySoulSand.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(@Nonnull IRegistry<ModelResourceLocation, IBakedModel> registry, final @Nonnull BlockModelShapes shapes, @Nonnull BlockRooty root) {
        shapes.func_178120_a().func_188181_b((Block)root).values().forEach(location -> registry.func_82595_a(location, (Object)new BakedModelWrapper<IBakedModel>(shapes.func_178126_b().func_174953_a(location)){

            @Nonnull
            public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                if (state instanceof IExtendedBlockState) {
                    IBlockState mimic = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)MimicProperty.MIMIC);
                    ImmutableList.Builder quads = ImmutableList.builder();
                    BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                    if (layer == null || mimic.func_177230_c().canRenderInLayer(mimic, layer)) {
                        IBakedModel mimicModel = shapes.func_178125_b(mimic);
                        quads.add((Object[])mimicModel.func_188616_a(mimic, side, rand).stream().map(quad -> quad.func_178212_b() ? this.offsetTintIndex((BakedQuad)quad) : quad).toArray(BakedQuad[]::new));
                    }
                    if (layer == null || layer == BlockRenderLayer.CUTOUT_MIPPED) {
                        quads.addAll((Iterable)this.originalModel.func_188616_a(state, side, rand));
                    }
                    return quads.build();
                }
                return this.originalModel.func_188616_a(state, side, rand);
            }

            @Nonnull
            BakedQuad offsetTintIndex(@Nonnull BakedQuad quad) {
                return new BakedQuad(quad.func_178209_a(), quad.func_178211_c() + 2, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
            }
        }));
    }
}

