/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import git.jbredwards.nether_api.api.util.PlantUtils;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootyEndStone;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootyNetherrack;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.block.BlockRootySoulSand;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public abstract class SpeciesPlantable
extends Species {
    public SpeciesPlantable() {
    }

    public SpeciesPlantable(@Nonnull ResourceLocation name, @Nonnull TreeFamily treeFamily) {
        super(name, treeFamily);
    }

    public SpeciesPlantable(@Nonnull ResourceLocation name, @Nonnull TreeFamily treeFamily, @Nonnull ILeavesProperties leavesProperties) {
        super(name, treeFamily, leavesProperties);
    }

    @Nonnull
    public BlockRooty getRootyBlock(@Nonnull World world, @Nonnull BlockPos rootPos) {
        BlockRooty soil;
        if (this.canSustainPlant(world, rootPos, world.func_180495_p(rootPos)) && (soil = this.getRootyBlock(this.getSimulatedPlantable().getPlantType((IBlockAccess)world, rootPos.func_177972_a(this.getGrowthDirection())))) != null) {
            return soil;
        }
        return super.getRootyBlock(world, rootPos);
    }

    @Nullable
    protected BlockRooty getRootyBlock(@Nonnull EnumPlantType soilType) {
        if (soilType == PlantUtils.NETHERRACK_PLANT_TYPE || soilType == PlantUtils.NETHER_PLANT_TYPE) {
            return BlockRootyNetherrack.INSTANCE;
        }
        if (soilType == PlantUtils.SOUL_SAND_PLANT_TYPE) {
            return BlockRootySoulSand.INSTANCE;
        }
        if (soilType == PlantUtils.END_PLANT_TYPE) {
            return BlockRootyEndStone.INSTANCE;
        }
        return null;
    }

    public boolean isAcceptableSoil(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState soilBlockState) {
        return this.isAcceptableSoil(soilBlockState) || this.canSustainPlant(world, pos, soilBlockState);
    }

    public boolean canSustainPlant(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, this.getGrowthDirection(), this.getSimulatedPlantable());
    }

    @Nonnull
    public abstract IPlantable getSimulatedPlantable();

    @Nonnull
    public EnumFacing getGrowthDirection() {
        return EnumFacing.UP;
    }
}

