/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.journey_into_the_light;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.compat.journey_into_the_light.BiomeJITL;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.journey.dimension.nether.JNWorldGenerator;
import net.journey.dimension.nether.biomes.BiomeRegister;
import net.journey.dimension.nether.biomes.NetherBiome;
import net.journey.dimension.nether.biomes.NetherBiomeEarthen;
import net.journey.dimension.nether.biomes.NetherBiomeForest;
import net.journey.dimension.nether.biomes.NetherBiomeForestEdge;
import net.journey.dimension.nether.biomes.NetherBiomeHeatSands;
import net.journey.dimension.nether.biomes.structure.IStructureWorld;
import net.journey.entity.mob.nether.EntityHellCow;
import net.journey.entity.mob.nether.EntityHellTurtle;
import net.journey.entity.mob.nether.EntityInfernoBlaze;
import net.journey.entity.mob.nether.EntityLavasnake;
import net.journey.entity.mob.nether.EntityMiniGhast;
import net.journey.entity.mob.nether.EntityReaper;
import net.journey.entity.mob.nether.EntityWitherspine;
import net.journey.init.blocks.JourneyBlocks;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.slayer.api.block.BlockModLeaves;

public final class JITLHandler {
    @Nonnull
    static final Map<Class<? extends NetherBiome>, BiomeJITL> BIOME_LOOKUP = new HashMap<Class<? extends NetherBiome>, BiomeJITL>(5);
    @Nonnull
    static final Method DOWN_RAY_METHOD = ObfuscationReflectionHelper.findMethod(JNWorldGenerator.class, (String)"downRay", BlockPos.class, (Class[])new Class[]{Chunk.class, BlockPos.class});
    @Nonnull
    static final Field PLANT_DENSITY_FIELD = ObfuscationReflectionHelper.findField(JNWorldGenerator.class, (String)"plantDensity");

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        if (BiomeRegister.BIOME_FOREST != null) {
            registry.registerBiome((Biome)JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_FOREST), NetherAPIConfig.JITL.bloodForestWeight);
        }
        if (BiomeRegister.BIOME_EARTHEN != null) {
            registry.registerBiome((Biome)JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_EARTHEN), NetherAPIConfig.JITL.earthenSeepWeight);
        }
        if (BiomeRegister.BIOME_HEAT_SANDS != null) {
            registry.registerBiome((Biome)JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_HEAT_SANDS), NetherAPIConfig.JITL.heatSandsWeight);
        }
    }

    public static void init() {
        BiomeJITL biome;
        if (BiomeRegister.BIOME_EMPTY_NETHER != null) {
            JITLHandler.getBiomeFromLookup((NetherBiome)BiomeRegister.BIOME_EMPTY_NETHER).netherBiome = BiomeRegister.BIOME_EMPTY_NETHER;
        }
        if (BiomeRegister.BIOME_FOREST != null) {
            JITLHandler.getBiomeFromLookup((NetherBiome)BiomeRegister.BIOME_FOREST).netherBiome = BiomeRegister.BIOME_FOREST;
        }
        if (BiomeRegister.BIOME_EARTHEN != null) {
            JITLHandler.getBiomeFromLookup((NetherBiome)BiomeRegister.BIOME_EARTHEN).netherBiome = BiomeRegister.BIOME_EARTHEN;
        }
        if (BiomeRegister.BIOME_HEAT_SANDS != null) {
            JITLHandler.getBiomeFromLookup((NetherBiome)BiomeRegister.BIOME_HEAT_SANDS).netherBiome = BiomeRegister.BIOME_HEAT_SANDS;
        }
        if (BiomeRegister.BIOME_FOREST_EDGE != null) {
            JITLHandler.getBiomeFromLookup((NetherBiome)BiomeRegister.BIOME_FOREST_EDGE).netherBiome = BiomeRegister.BIOME_FOREST_EDGE;
        }
        EntityRegistry.removeSpawn(EntityLavasnake.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityWitherspine.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityReaper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityHellCow.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityMiniGhast.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityInfernoBlaze.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        EntityRegistry.removeSpawn(EntityHellTurtle.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        if (BiomeRegister.BIOME_FOREST != null) {
            biome = JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_FOREST);
            EntityRegistry.addSpawn(EntityHellCow.class, (int)15, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            EntityRegistry.addSpawn(EntityMiniGhast.class, (int)3, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            EntityRegistry.addSpawn(EntityInfernoBlaze.class, (int)2, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
        }
        if (BiomeRegister.BIOME_EARTHEN != null) {
            biome = JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_EARTHEN);
            EntityRegistry.addSpawn(EntityWitherspine.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            EntityRegistry.addSpawn(EntityReaper.class, (int)8, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
        }
        if (BiomeRegister.BIOME_HEAT_SANDS != null) {
            biome = JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_HEAT_SANDS);
            EntityRegistry.addSpawn(EntityLavasnake.class, (int)15, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            EntityRegistry.addSpawn(EntityHellTurtle.class, (int)15, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
        }
        if (BiomeRegister.BIOME_FOREST_EDGE != null) {
            biome = JITLHandler.getBiomeFromLookup(BiomeRegister.BIOME_FOREST_EDGE);
            EntityRegistry.addSpawn(EntityHellCow.class, (int)15, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
        }
        ObfuscationReflectionHelper.setPrivateValue(BlockModLeaves.class, (Object)((BlockModLeaves)JourneyBlocks.sizzlerWoodLeaves), (Object)JourneyBlocks.netherSapling, (String)"sapling");
        ObfuscationReflectionHelper.setPrivateValue(BlockModLeaves.class, (Object)((BlockModLeaves)JourneyBlocks.earthenNetherLeaves), (Object)JourneyBlocks.EARTHEN_SAPLING, (String)"sapling");
    }

    @Nonnull
    public static BiomeJITL getBiomeFromLookup(@Nonnull NetherBiome netherBiome) {
        BiomeJITL biome = BIOME_LOOKUP.get(netherBiome.getClass());
        if (biome != null) {
            return biome;
        }
        throw new IllegalStateException("No Biome found for Journey Into The Light: {" + netherBiome.getName() + '}');
    }

    @SubscribeEvent
    static void registerBiomes(@Nonnull RegistryEvent.Register<Biome> event) {
        BiConsumer<Class, String> registerAction = (netherBiomeClass, biomeName) -> {
            BiomeJITL biome = new BiomeJITL((Class<? extends NetherBiome>)netherBiomeClass, (String)biomeName);
            event.getRegistry().register((IForgeRegistryEntry)biome);
            BIOME_LOOKUP.put((Class<? extends NetherBiome>)netherBiomeClass, biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        };
        registerAction.accept(NetherBiome.class, "Empty Nether");
        registerAction.accept(NetherBiomeForest.class, "Blood Forest");
        registerAction.accept(NetherBiomeEarthen.class, "Earthen Seep");
        registerAction.accept(NetherBiomeHeatSands.class, "Heat Sands");
        registerAction.accept(NetherBiomeForestEdge.class, "Blood Forest Edge");
    }

    @SubscribeEvent
    static void globalNetherPopulations(@Nonnull PopulateChunkEvent.Post event) throws InvocationTargetException, IllegalAccessException {
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER && event.getWorld().func_175624_G() != WorldType.field_180272_g) {
            float plantDensity;
            BlockFalling.field_149832_M = true;
            if ((JNWorldGenerator.globalStructuresLand.length != 0 || JNWorldGenerator.globalStructuresLava.length != 0 || JNWorldGenerator.globalStructuresCave.length != 0) && event.getRand().nextInt(16) == 0) {
                int x = (event.getChunkX() << 4) + event.getRand().nextInt(16) + 8;
                int z = (event.getChunkZ() << 4) + event.getRand().nextInt(16) + 8;
                BlockPos.MutableBlockPos start = new BlockPos.MutableBlockPos(x, MathHelper.func_76136_a((Random)event.getRand(), (int)32, (int)(event.getWorld().func_72940_L() - 40)), z);
                Chunk chunk = event.getWorld().func_175726_f((BlockPos)start);
                while (start.func_177956_o() > 32 && !chunk.func_177435_g((BlockPos)start).func_177230_c().isAir(chunk.func_177435_g((BlockPos)start), (IBlockAccess)event.getWorld(), (BlockPos)start)) {
                    start.func_185336_p(start.func_177956_o() - 1);
                }
                BlockPos rayPos = (BlockPos)DOWN_RAY_METHOD.invoke(null, chunk, start);
                if (rayPos != null) {
                    boolean terrain = true;
                    for (int y = 1; y < 8; ++y) {
                        if (chunk.func_177435_g(rayPos.func_177981_b(y)).func_177230_c().isAir(chunk.func_177435_g(rayPos.func_177981_b(y)), (IBlockAccess)event.getWorld(), rayPos.func_177981_b(y))) continue;
                        terrain = false;
                        break;
                    }
                    if (terrain) {
                        if (JNWorldGenerator.globalStructuresLava.length != 0 && chunk.func_177435_g(rayPos).func_185904_a() == Material.field_151587_i) {
                            IStructureWorld structure = JNWorldGenerator.globalStructuresLava[event.getRand().nextInt(JNWorldGenerator.globalStructuresLava.length)];
                            structure.generateSurface(event.getWorld(), rayPos.func_177984_a(), event.getRand());
                        } else if (JNWorldGenerator.globalStructuresLand.length != 0) {
                            IStructureWorld structure = JNWorldGenerator.globalStructuresLand[event.getRand().nextInt(JNWorldGenerator.globalStructuresLand.length)];
                            structure.generateSurface(event.getWorld(), rayPos.func_177984_a(), event.getRand());
                        }
                    } else if (JNWorldGenerator.globalStructuresCave.length != 0) {
                        IStructureWorld structure = JNWorldGenerator.globalStructuresCave[event.getRand().nextInt(JNWorldGenerator.globalStructuresCave.length)];
                        structure.generateSubterrain(event.getWorld(), rayPos, event.getRand());
                    }
                }
            }
            try {
                plantDensity = PLANT_DENSITY_FIELD.getFloat(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            BlockPos.func_191531_b((int)(chunk.field_76635_g << 4), (int)0, (int)(chunk.field_76647_h << 4), (int)(chunk.field_76635_g << 4 | 0xF), (int)0, (int)(chunk.field_76647_h << 4 | 0xF)).forEach(pos -> {
                NetherBiome netherBiome;
                Biome biome = chunk.func_177411_a((BlockPos)pos, event.getWorld().func_72959_q());
                if (biome instanceof BiomeJITL && (netherBiome = ((BiomeJITL)biome).netherBiome) != null) {
                    for (int y = 5; y < event.getWorld().func_72940_L() - 5; ++y) {
                        pos.func_185336_p(y);
                        if (!chunk.func_177435_g((BlockPos)pos).func_185917_h()) continue;
                        Material above = chunk.func_177435_g(pos.func_177984_a()).func_185904_a();
                        if (!above.func_76224_d() && !above.func_76220_a()) {
                            netherBiome.genSurfColumn(chunk, (BlockPos)pos, event.getRand());
                            if (!(event.getRand().nextFloat() < plantDensity)) continue;
                            netherBiome.genFloorObjects(chunk, (BlockPos)pos, event.getRand());
                            continue;
                        }
                        Material below = chunk.func_177435_g(pos.func_177977_b()).func_185904_a();
                        if (below.func_76224_d() || below.func_76220_a() || !(event.getRand().nextFloat() < plantDensity)) continue;
                        netherBiome.genCeilObjects(chunk, (BlockPos)pos, event.getRand());
                    }
                    pos.func_185336_p(0);
                }
            });
            BlockFalling.field_149832_M = false;
        }
    }
}

