/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.stygian_end;

import fluke.stygian.block.ModBlocks;
import fluke.stygian.world.BiomeRegistrar;
import git.jbredwards.nether_api.api.biome.IEndBiome;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class AbstractStygianEndBiome
extends BiomeEnd
implements IEndBiome {
    public AbstractStygianEndBiome(@Nonnull Biome.BiomeProperties properties) {
        super(properties);
    }

    @Override
    public void buildSurface(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, @Nonnull ChunkPrimer primer, int x, int z, double terrainNoise) {
        int currDepth = -1;
        for (int y = chunkGenerator.getWorld().func_72940_L() - 1; y >= 0; --y) {
            IBlockState here = primer.func_177856_a(x, y, z);
            if (here.func_185904_a() == Material.field_151579_a) {
                currDepth = -1;
                continue;
            }
            if (here.func_177230_c() != Blocks.field_150377_bs) continue;
            if (currDepth == -1) {
                currDepth = 3 + chunkGenerator.getRand().nextInt(2);
                primer.func_177855_a(x, y, z, this.field_76752_A);
                continue;
            }
            if (currDepth <= 0) continue;
            --currDepth;
            primer.func_177855_a(x, y, z, this.field_76753_B);
        }
    }

    @Override
    public boolean generateChorusPlants(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, float islandHeight) {
        return this == BiomeRegistrar.END_JUNGLE ? NetherAPIConfig.StygianEnd.endJungleChorusPlants : NetherAPIConfig.StygianEnd.endVolcanoChorusPlants;
    }

    @Override
    public boolean generateEndCity(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, int islandHeight) {
        return islandHeight >= 60 && (this == BiomeRegistrar.END_JUNGLE ? NetherAPIConfig.StygianEnd.endJungleEndCity : NetherAPIConfig.StygianEnd.endVolcanoEndCity);
    }

    @Override
    public boolean generateIslands(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, float islandHeight) {
        if (this == BiomeRegistrar.END_VOLCANO) {
            if (chunkGenerator.getRand().nextBoolean()) {
                if (islandHeight < -20.0f && chunkGenerator.getRand().nextInt(14) == 0) {
                    WorldGenerator feature = new WorldGenerator(){

                        public boolean func_180709_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos position) {
                            float radius = rand.nextInt(3) + 4;
                            int y = 0;
                            while ((double)radius > 0.5) {
                                for (int x = MathHelper.func_76141_d((float)(-radius)); x <= MathHelper.func_76123_f((float)radius); ++x) {
                                    for (int z = MathHelper.func_76141_d((float)(-radius)); z <= MathHelper.func_76123_f((float)radius); ++z) {
                                        if (!((float)(x * x + z * z) <= (radius + 1.0f) * (radius + 1.0f))) continue;
                                        this.func_175903_a(worldIn, position.func_177982_a(x, y, z), ModBlocks.endObsidian.func_176223_P());
                                    }
                                }
                                radius = (float)((double)radius - ((double)rand.nextInt(2) + 0.5));
                                --y;
                            }
                            return true;
                        }
                    };
                    feature.func_180709_b(chunkGenerator.getWorld(), chunkGenerator.getRand(), new BlockPos((chunkX << 4) + chunkGenerator.getRand().nextInt(16) + 8, chunkGenerator.getRand().nextInt(16) + 55, (chunkZ << 4) + chunkGenerator.getRand().nextInt(16) + 8));
                    if (chunkGenerator.getRand().nextInt(4) == 0) {
                        feature.func_180709_b(chunkGenerator.getWorld(), chunkGenerator.getRand(), new BlockPos((chunkX << 4) + chunkGenerator.getRand().nextInt(16) + 8, chunkGenerator.getRand().nextInt(16) + 55, (chunkZ << 4) + chunkGenerator.getRand().nextInt(16) + 8));
                    }
                }
                return false;
            }
        } else {
            return islandHeight < -25.0f;
        }
        return true;
    }
}

