/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageTeleportFX
implements IMessage {
    public double x;
    public double y;
    public double z;
    public double prevX;
    public double prevY;
    public double prevZ;
    public float width;
    public float height;
    public boolean valid;

    public MessageTeleportFX() {
    }

    public MessageTeleportFX(@Nonnull Entity entityIn, double prevXIn, double prevYIn, double prevZIn) {
        this.valid = true;
        this.x = entityIn.field_70165_t;
        this.y = entityIn.field_70163_u;
        this.z = entityIn.field_70161_v;
        this.prevX = prevXIn;
        this.prevY = prevYIn;
        this.prevZ = prevZIn;
        this.width = entityIn.field_70130_N;
        this.height = entityIn.field_70131_O;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.valid = buf.readBoolean();
        if (this.valid) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.prevX = buf.readDouble();
            this.prevY = buf.readDouble();
            this.prevZ = buf.readDouble();
            this.width = buf.readFloat();
            this.height = buf.readFloat();
        }
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeBoolean(this.valid);
        if (this.valid) {
            buf.writeDouble(this.x).writeDouble(this.y).writeDouble(this.z).writeDouble(this.prevX).writeDouble(this.prevY).writeDouble(this.prevZ).writeFloat(this.width).writeFloat(this.height);
        }
    }

    public static enum Handler implements IMessageHandler<MessageTeleportFX, IMessage>
    {
        INSTANCE;


        @Nullable
        public IMessage onMessage(@Nonnull MessageTeleportFX msg, @Nonnull MessageContext ctx) {
            if (msg.valid && ctx.side.isClient()) {
                Handler.onMessageClient(msg);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        static void onMessageClient(@Nonnull MessageTeleportFX msg) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                double scale = 0.007874015748031496;
                for (double slide = 0.0; slide <= 1.0; slide += 0.007874015748031496) {
                    Minecraft.func_71410_x().field_71438_f.func_174972_a(EnumParticleTypes.PORTAL, msg.prevX + (msg.x - msg.prevX) * slide + (Math.random() - 0.5) * (double)msg.width * 2.0, msg.prevY + (msg.y - msg.prevY) * slide + Math.random() * (double)msg.height, msg.prevZ + (msg.z - msg.prevZ) * slide + (Math.random() - 0.5) * (double)msg.width * 2.0, (Math.random() - 0.5) * 0.2, (Math.random() - 0.5) * 0.2, (Math.random() - 0.5) * 0.2, new int[0]);
                }
            });
        }
    }
}

