/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.registry;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistryListener;
import git.jbredwards.nether_api.api.structure.INetherAPIStructureEntry;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIStructureEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.GameData;

public class NetherAPIRegistry
implements INetherAPIRegistry {
    public static NetherAPIRegistry NETHER;
    public static NetherAPIRegistry THE_END;
    @Nonnull
    protected final ResourceLocation location;
    @Nonnull
    protected final List<BiomeManager.BiomeEntry> biomeEntries = new ArrayList<BiomeManager.BiomeEntry>();
    @Nonnull
    protected final List<INetherAPIStructureEntry> structureEntries = new ArrayList<INetherAPIStructureEntry>();

    public static void init() {
        NETHER = new NetherAPIRegistry("nether");
        THE_END = new NetherAPIRegistry("end");
    }

    public NetherAPIRegistry(@Nonnull String namespace) {
        this.location = GameData.checkPrefix((String)namespace, (boolean)true);
        REGISTRIES.add(this);
    }

    @Override
    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.location;
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getBiomeEntries() {
        return Collections.unmodifiableList(this.biomeEntries);
    }

    @Override
    @Nonnull
    public List<INetherAPIStructureEntry> getStructures() {
        return Collections.unmodifiableList(this.structureEntries);
    }

    @Override
    public void registerBiome(@Nonnull Biome biome, int weight) {
        if (biome.delegate.name() == null) {
            throw new IllegalArgumentException("Biome must be registered!");
        }
        if (weight < 1) {
            return;
        }
        this.removeBiome(biome);
        this.biomeEntries.add(new BiomeManager.BiomeEntry(biome, weight));
        if (biome instanceof INetherAPIRegistryListener) {
            ((INetherAPIRegistryListener)biome).onAddedToRegistry(this, OptionalInt.of(weight));
        }
    }

    @Override
    public boolean removeBiome(@Nonnull Biome biome) {
        return this.biomeEntries.removeIf(entry -> {
            if (entry.biome == biome) {
                if (biome instanceof INetherAPIRegistryListener) {
                    ((INetherAPIRegistryListener)biome).onRemovedFromRegistry(this, OptionalInt.of(entry.field_76292_a));
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void registerStructure(@Nonnull INetherAPIStructureEntry structureEntry) {
        this.removeStructure(structureEntry.getCommandName());
        this.structureEntries.add(structureEntry);
        if (structureEntry instanceof INetherAPIRegistryListener) {
            ((INetherAPIRegistryListener)((Object)structureEntry)).onAddedToRegistry(this, OptionalInt.empty());
        }
    }

    @Override
    public void registerStructure(@Nonnull String commandName, @Nonnull Function<INetherAPIChunkGenerator, MapGenStructure> structureFactory) {
        this.registerStructure(new NetherAPIStructureEntry(commandName, structureFactory));
    }

    @Override
    public boolean removeStructure(@Nonnull String commandName) {
        return this.structureEntries.removeIf(entry -> {
            if (entry.getCommandName().equals(commandName)) {
                if (entry instanceof INetherAPIRegistryListener) {
                    ((INetherAPIRegistryListener)((Object)entry)).onRemovedFromRegistry(this, OptionalInt.empty());
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void clear() {
        Object entry;
        Iterator<Object> it = this.biomeEntries.iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (entry.biome instanceof INetherAPIRegistryListener) {
                ((INetherAPIRegistryListener)entry.biome).onRemovedFromRegistry(this, OptionalInt.of(entry.field_76292_a));
            }
            it.remove();
        }
        it = this.structureEntries.iterator();
        while (it.hasNext()) {
            entry = (INetherAPIStructureEntry)it.next();
            if (entry instanceof INetherAPIRegistryListener) {
                ((INetherAPIRegistryListener)entry).onRemovedFromRegistry(this, OptionalInt.empty());
            }
            it.remove();
        }
    }
}

