/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world;

import git.jbredwards.nether_api.api.audio.IDarkSoundAmbience;
import git.jbredwards.nether_api.api.biome.IAmbienceBiome;
import git.jbredwards.nether_api.api.biome.IEndBiome;
import git.jbredwards.nether_api.api.event.NetherAPIFogColorEvent;
import git.jbredwards.nether_api.api.util.NetherGenerationUtils;
import git.jbredwards.nether_api.api.world.IAmbienceWorldProvider;
import git.jbredwards.nether_api.mod.client.audio.TheEndMusicHandler;
import git.jbredwards.nether_api.mod.common.compat.voidislandcontrol.VoidIslandControlHandler;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import git.jbredwards.nether_api.mod.common.world.IFogWorldProvider;
import git.jbredwards.nether_api.mod.common.world.PlayerSpawnLogic;
import git.jbredwards.nether_api.mod.common.world.biome.BiomeProviderTheEnd;
import git.jbredwards.nether_api.mod.common.world.gen.ChunkGeneratorTheEnd;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenEndGateway;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraft.world.gen.feature.WorldGenSpikes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderTheEnd
extends WorldProviderEnd
implements IAmbienceWorldProvider,
IFogWorldProvider {
    @Nonnull
    public static ExitPortal EXIT_PORTAL = WorldGenEndPodium::new;
    @Nonnull
    public static WorldGenerator END_GATEWAY = new WorldGenEndGateway();
    @Nonnull
    public static WorldGenSpikes END_PILLAR = new WorldGenSpikes();
    @Nonnull
    public static WorldGenerator OBSIDIAN_PLATFORM = new WorldGenerator(){

        public boolean func_180709_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos position) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    worldIn.func_175656_a(position.func_177982_a(x, -2, z), Blocks.field_150343_Z.func_176223_P());
                    for (int y = -1; y < 2; ++y) {
                        worldIn.func_175656_a(position.func_177982_a(x, y, z), Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            return true;
        }
    };
    @Nullable
    protected static Boolean initialPortalLit = null;
    public static boolean forceExtraEndFog = false;

    public void setDimension(int dim) {
        if (DimensionManager.getProviderType((int)dim).field_186077_g != this.getClass()) {
            throw new IllegalArgumentException("Invalid dimension ID: " + dim);
        }
        super.setDimension(dim);
    }

    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderTheEnd(this.field_76579_a);
        if (this.field_76579_a instanceof WorldServer) {
            NBTTagCompound nbt = this.field_76579_a.func_72912_H().getDimensionData(this.getDimension());
            this.field_186064_g = new FightManager((WorldServer)this.field_76579_a, nbt.func_74775_l("DragonFight"));
        }
    }

    @Nonnull
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorTheEnd(this.field_76579_a, VoidIslandControlHandler.isMapFeaturesEnabled(this.field_76579_a), (BiomeProviderTheEnd)this.field_76578_c, this.func_177496_h());
    }

    @Nonnull
    public BlockPos func_177496_h() {
        return VoidIslandControlHandler.getEndSpawnPos(super.func_177496_h());
    }

    @Nonnull
    public Random createSeedRandom(@Nonnull BlockPos pos) {
        return NetherGenerationUtils.createSeedRandom(this.field_76579_a.func_72905_C(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static void overrideInitialPortalLit(boolean value) {
        initialPortalLit = value;
    }

    @Nonnull
    public BlockPos getRandomizedSpawnPoint() {
        OBSIDIAN_PLATFORM.func_180709_b(this.field_76579_a, new Random(this.field_76579_a.func_72905_C()), this.func_177496_h());
        return super.getRandomizedSpawnPoint();
    }

    @Override
    @Nullable
    public IDarkSoundAmbience getDarkAmbienceSound(@Nonnull Biome biome) {
        return biome instanceof IAmbienceBiome ? ((IAmbienceBiome)biome).getDarkAmbienceSound() : null;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return this.getFogColor(this.field_76579_a, celestialAngle, partialTicks, 0.09411766, 0.07529412, 0.09411766, NetherAPIFogColorEvent.End::new);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d getDefaultFogColor(@Nonnull Biome biome, float celestialAngle, float partialTicks, double defaultR, double defaultG, double defaultB) {
        return biome instanceof IEndBiome ? ((IEndBiome)biome).getFogColor(celestialAngle, partialTicks) : new Vec3d(defaultR, defaultG, defaultB);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return TheEndMusicHandler.getMusicType();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        if (forceExtraEndFog) {
            return true;
        }
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(x, 0, z));
        return biome instanceof IEndBiome && ((IEndBiome)biome).hasExtraXZFog(this.field_76579_a, x, z);
    }

    protected class FightManager
    extends DragonFightManager {
        public boolean initialDragon;
        public boolean initialDragonKilled;

        public FightManager(@Nonnull WorldServer worldIn, NBTTagCompound compound) {
            super(worldIn, compound);
            this.initialDragon = NetherAPIConfig.initialDragon;
            this.initialDragonKilled = false;
            if (compound.func_150297_b("nether_api:initialDragon", 99)) {
                this.initialDragon = compound.func_74767_n("nether_api:initialDragon");
                this.initialDragonKilled = compound.func_74767_n("nether_api:initialDragonKilled");
            } else if (!compound.func_82582_d()) {
                this.initialDragonKilled = this.field_186117_k;
            }
        }

        @Nonnull
        public NBTTagCompound func_186088_a() {
            NBTTagCompound nbt = super.func_186088_a();
            nbt.func_74757_a("nether_api:initialDragon", this.initialDragon);
            nbt.func_74757_a("nether_api:initialDragonKilled", this.initialDragonKilled);
            return nbt;
        }

        public void func_186105_b() {
            if (!this.initialDragon && this.field_186120_n) {
                List dragons = WorldProviderTheEnd.this.field_76579_a.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
                if (!dragons.isEmpty()) {
                    ((EntityDragon)dragons.get(0)).func_70106_y();
                }
                this.func_186094_a(true);
                this.func_186097_l();
                this.field_186117_k = true;
                this.field_186118_l = false;
                this.field_186120_n = false;
            }
            super.func_186105_b();
        }

        public void func_186089_a(@Nonnull BlockPos pos) {
            if (!this.field_186120_n) {
                WorldProviderTheEnd.this.field_76579_a.func_175718_b(3000, pos, 0);
            }
            END_GATEWAY.func_180709_b(WorldProviderTheEnd.this.field_76579_a, WorldProviderTheEnd.this.createSeedRandom(pos), pos);
        }

        public void func_186094_a(boolean active) {
            if (this.field_186121_o == null) {
                this.field_186121_o = WorldProviderTheEnd.this.field_76579_a.func_175672_r(WorldGenEndPodium.field_186139_a).func_177977_b();
                int exitPortalMinY = Math.max(WorldProviderTheEnd.this.field_76579_a.func_181545_F(), 2);
                Chunk chunk = WorldProviderTheEnd.this.field_76579_a.func_175726_f(this.field_186121_o);
                while (this.field_186121_o.func_177956_o() > exitPortalMinY && chunk.func_177435_g(this.field_186121_o).func_177230_c() == Blocks.field_150357_h) {
                    this.field_186121_o = this.field_186121_o.func_177977_b();
                }
                if (this.field_186121_o.func_177956_o() < 2) {
                    this.field_186121_o = new BlockPos(this.field_186121_o.func_177958_n(), exitPortalMinY, this.field_186121_o.func_177952_p());
                }
            }
            EXIT_PORTAL.create(this.spawnPortalLit(active)).func_180709_b(WorldProviderTheEnd.this.field_76579_a, WorldProviderTheEnd.this.createSeedRandom(this.field_186121_o), this.field_186121_o);
        }

        public void func_186096_a(@Nonnull EntityDragon dragon) {
            if (dragon.func_110124_au().equals(this.field_186119_m)) {
                this.initialDragonKilled = true;
            }
            super.func_186096_a(dragon);
        }

        protected boolean spawnPortalLit(boolean active) {
            if (!active) {
                return false;
            }
            if (this.initialDragonKilled) {
                return true;
            }
            if (initialPortalLit != null) {
                return initialPortalLit;
            }
            return PlayerSpawnLogic.getInitialSpawnDimension(null) != WorldProviderTheEnd.this.getDimension();
        }
    }

    @FunctionalInterface
    public static interface ExitPortal {
        public WorldGenerator create(boolean var1);
    }
}

