/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.biome;

import git.jbredwards.nether_api.api.event.NetherAPIBiomeSizeEvent;
import git.jbredwards.nether_api.api.event.NetherAPIInitBiomeGensEvent;
import git.jbredwards.nether_api.api.event.NetherAPIRegistryEvent;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.world.biome.BiomeProviderNetherAPI;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerEnd;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherBiomes;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherEdgeBiomes;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherSubBiomes;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeProviderTheEnd
extends BiomeProviderNetherAPI {
    @Nonnull
    public final NoiseGeneratorSimplex islandNoise;

    public BiomeProviderTheEnd(@Nonnull World world) {
        super(world, NetherAPIRegistry.THE_END, NetherAPIRegistryEvent.End::new);
        this.islandNoise = new NoiseGeneratorSimplex(new Random(world.func_72905_C()));
    }

    @Override
    @Nonnull
    public GenLayer[] getBiomeGenerators(@Nonnull WorldType worldType, long seed, @Nonnull INetherAPIRegistry registry) {
        NetherAPIBiomeSizeEvent.End event = new NetherAPIBiomeSizeEvent.End(worldType, 3);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        GenLayerFuzzyZoom biomeLayerBase = new GenLayerFuzzyZoom(10L, (GenLayer)new GenLayerNetherBiomes(20L, registry));
        GenLayer biomeLayerWithSub = GenLayerZoom.func_75915_a((long)10L, (GenLayer)new GenLayerNetherSubBiomes(20L, (GenLayer)biomeLayerBase), (int)event.biomeSize);
        GenLayerNetherEdgeBiomes biomeLayerWithEdge = new GenLayerNetherEdgeBiomes(20L, biomeLayerWithSub);
        GenLayerSmooth biomeLayer = new GenLayerSmooth(10L, (GenLayer)new GenLayerSmooth(10L, GenLayerZoom.func_75915_a((long)10L, (GenLayer)biomeLayerWithEdge, (int)2)));
        GenLayerVoronoiZoom indexLayer = new GenLayerVoronoiZoom(10L, (GenLayer)biomeLayer);
        indexLayer.func_75905_a(seed);
        return new GenLayer[]{new GenLayerEnd(this, (GenLayer)biomeLayer), new GenLayerEnd(this, (GenLayer)indexLayer)};
    }

    @Override
    @Nonnull
    public GenLayer[] getModdedBiomeGenerators(@Nonnull WorldType worldType, long seed, @Nonnull GenLayer[] original) {
        NetherAPIInitBiomeGensEvent.End event = new NetherAPIInitBiomeGensEvent.End(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.biomeGenerators;
    }
}

