/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.gen.layer;

import git.jbredwards.nether_api.mod.common.world.biome.BiomeProviderTheEnd;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerEnd
extends GenLayer {
    protected static final int END_ID = Biome.func_185362_a((Biome)Biomes.field_76779_k);
    protected static final int VOID_ID = Biome.func_185362_a((Biome)Biomes.field_185440_P);
    @Nonnull
    protected final BiomeProviderTheEnd biomeProvider;

    public GenLayerEnd(@Nonnull BiomeProviderTheEnd biomeProviderIn, @Nonnull GenLayer parentIn) {
        super(1L);
        this.field_75909_a = parentIn;
        this.biomeProvider = biomeProviderIn;
    }

    @Nonnull
    public int[] func_75904_a(int areaX, int areaZ, int areaWidth, int areaHeight) {
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        if ((long)(areaX >> 4) * (long)(areaX >> 4) + (long)(areaZ >> 4) * (long)(areaZ >> 4) <= 2048L) {
            Arrays.fill(out, END_ID);
        } else {
            int[] biomeIds = this.field_75909_a.func_75904_a(areaX, areaZ, areaWidth, areaHeight);
            for (int x = 0; x < areaWidth; ++x) {
                int blockX = areaX + x;
                for (int z = 0; z < areaHeight; ++z) {
                    int index = x + z * areaHeight;
                    out[index] = biomeIds[index];
                }
            }
        }
        return out;
    }

    protected boolean isVoidAt(int blockX, int blockZ) {
        double vanillaBlockX = (double)blockX / 8.0 + 1.0;
        double vanillaBlockZ = (double)blockX / 8.0 + 1.0;
        double chunkX = (double)blockX / 16.0;
        double chunkZ = (double)blockZ / 16.0;
        double height = 100.0 - Math.sqrt(vanillaBlockX * vanillaBlockX + vanillaBlockZ * vanillaBlockZ) * 8.0;
        for (int x = -12; x <= 12; ++x) {
            double offsetX = chunkX + (double)x;
            for (int z = -12; z <= 12; ++z) {
                double offsetZ = chunkZ + (double)z;
                if (!(offsetX * offsetX + offsetZ * offsetZ > 2048.0) || !(this.biomeProvider.islandNoise.func_151605_a(offsetX, offsetZ) < -0.9)) continue;
                double scale = (Math.abs(offsetX) * 3439.0 + Math.abs(offsetZ) * 147.0) % 13.0 + 9.0;
                double fracX = 1 - (x << 1);
                double fracZ = 1 - (z << 1);
                double newHeight = 100.0 - Math.sqrt(fracX * fracX + fracZ * fracZ) * scale;
                if (!(height < newHeight)) continue;
                height = newHeight;
            }
        }
        return height < -20.0;
    }
}

