/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.util;

import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.compat.netherex.NetherExHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public final class NetherGenerationUtils {
    public static void buildSurfaceAndSoulSandGravel(@Nonnull World world, @Nonnull Random rand, @Nonnull ChunkPrimer primer, int x, int z, double[] soulSandNoise, double[] gravelNoise, double[] depthBuffer, @Nonnull IBlockState stateToFill, @Nonnull IBlockState topBlockIn, @Nonnull IBlockState fillerBlockIn, @Nonnull IBlockState liquidBlockIn) {
        NetherGenerationUtils.buildSurfaceAndSoulSandGravel(world, rand, primer, x, z, soulSandNoise, gravelNoise, depthBuffer, stateToFill, topBlockIn, fillerBlockIn, liquidBlockIn, Blocks.field_150351_n.func_176223_P(), Blocks.field_150425_aM.func_176223_P());
    }

    public static void buildSurfaceAndSoulSandGravel(@Nonnull World world, @Nonnull Random rand, @Nonnull ChunkPrimer primer, int x, int z, double[] soulSandNoise, double[] gravelNoise, double[] depthBuffer, @Nonnull IBlockState stateToFill, @Nonnull IBlockState topBlockIn, @Nonnull IBlockState fillerBlockIn, @Nonnull IBlockState liquidBlockIn, @Nonnull IBlockState gravelIn, @Nonnull IBlockState sandIn) {
        boolean soulSand = (!NetherAPI.isNetherExLoaded || NetherExHandler.doesSoulSandGenerate() || sandIn.func_177230_c() != Blocks.field_150425_aM) && soulSandNoise[x << 4 | z] + rand.nextDouble() * 0.2 > 0.0;
        boolean gravel = (!NetherAPI.isNetherExLoaded || NetherExHandler.doesGravelGenerate() || gravelIn.func_177230_c() != Blocks.field_150351_n) && gravelNoise[x << 4 | z] + rand.nextDouble() * 0.2 > 0.0;
        int depth = (int)(depthBuffer[x << 4 | z] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int depthRemaining = -1;
        int seaLevel = world.func_181545_F() + 1;
        IBlockState topBlock = topBlockIn;
        IBlockState fillerBlock = fillerBlockIn;
        IBlockState prevCheckState = Blocks.field_150350_a.func_176223_P();
        for (int y = world.func_72940_L() - 1; y >= 0; --y) {
            IBlockState checkState = primer.func_177856_a(x, y, z);
            if (checkState.func_185904_a() != Material.field_151579_a) {
                if (checkState == stateToFill) {
                    if (depthRemaining == -1) {
                        if (depth <= 0) {
                            fillerBlock = fillerBlockIn;
                        } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                            topBlock = topBlockIn;
                            fillerBlock = fillerBlockIn;
                            if (gravel) {
                                topBlock = gravelIn;
                            }
                            if (soulSand) {
                                topBlock = sandIn;
                                fillerBlock = sandIn;
                            }
                        }
                        if (y < seaLevel && topBlock.func_185904_a() == Material.field_151579_a) {
                            topBlock = liquidBlockIn;
                        }
                        depthRemaining = depth;
                        if (prevCheckState.func_185904_a() == Material.field_151579_a) {
                            primer.func_177855_a(x, y, z, topBlock);
                            prevCheckState = topBlock;
                            continue;
                        }
                        primer.func_177855_a(x, y, z, fillerBlock);
                        prevCheckState = fillerBlock;
                        continue;
                    }
                    if (depthRemaining > 0) {
                        --depthRemaining;
                        primer.func_177855_a(x, y, z, fillerBlock);
                        prevCheckState = fillerBlock;
                        continue;
                    }
                    prevCheckState = checkState;
                    continue;
                }
                prevCheckState = checkState;
                continue;
            }
            depthRemaining = -1;
            prevCheckState = checkState;
        }
    }

    @Nonnull
    public static Random createSeedRandom(long seed, int chunkX, int chunkZ) {
        Random rand = new Random(seed);
        rand.setSeed((rand.nextLong() >> 3) * (long)chunkX + (rand.nextLong() >> 3) * (long)chunkZ ^ seed);
        return rand;
    }
}

