/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.util;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public final class PlantUtils {
    @Nonnull
    public static final EnumPlantType END_PLANT_TYPE = EnumPlantType.getPlantType((String)"ender");
    @Nonnull
    public static final EnumPlantType NETHER_PLANT_TYPE = EnumPlantType.getPlantType((String)"nether_api:nether");
    @Nonnull
    public static final EnumPlantType NETHERRACK_PLANT_TYPE = EnumPlantType.getPlantType((String)"nether_api:netherrack");
    @Nonnull
    public static final EnumPlantType SOUL_SAND_PLANT_TYPE = EnumPlantType.Nether;

    public static boolean sustainsNether(@Nonnull EnumPlantType soilType, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
        return PlantUtils.sustainsNether(soilType, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public static boolean sustainsNether(@Nonnull EnumPlantType soilType, @Nonnull EnumPlantType plantType) {
        return plantType == soilType || (soilType == NETHER_PLANT_TYPE ? plantType == NETHERRACK_PLANT_TYPE || plantType == SOUL_SAND_PLANT_TYPE : plantType == NETHER_PLANT_TYPE);
    }

    @Nonnull
    public static IPlantable createPlantable(@Nonnull EnumPlantType plantType) {
        return PlantUtils.createPlantable(plantType, Blocks.field_150350_a.func_176223_P());
    }

    @Nonnull
    public static IPlantable createPlantable(final @Nonnull EnumPlantType plantType, final @Nonnull IBlockState plant) {
        return new IPlantable(){

            @Nonnull
            public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
                return plantType;
            }

            @Nonnull
            public IBlockState getPlant(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
                return plant;
            }
        };
    }
}

