/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.world;

import git.jbredwards.nether_api.api.audio.IDarkSoundAmbience;
import git.jbredwards.nether_api.api.audio.ISoundAmbience;
import git.jbredwards.nether_api.api.audio.impl.DarkSoundAmbience;
import git.jbredwards.nether_api.api.biome.IAmbienceBiome;
import git.jbredwards.nether_api.api.event.BiomeAmbienceEvent;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IAmbienceWorldProvider {
    @Nullable
    public static <T> T getAmbienceOrFallback(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Biome biome, @Nonnull Class<T> ambienceType, @Nonnull BiFunction<IAmbienceWorldProvider, Biome, T> pFun, @Nonnull Function<IAmbienceBiome, T> bFun, @Nullable T fallback) {
        BiomeAmbienceEvent<T> event = new BiomeAmbienceEvent<T>(ambienceType, biome, world, pos);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.ambience;
        }
        return world.field_73011_w instanceof IAmbienceWorldProvider ? pFun.apply((IAmbienceWorldProvider)world.field_73011_w, biome) : (biome instanceof IAmbienceBiome ? bFun.apply((IAmbienceBiome)biome) : fallback);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    default public IParticleFactory[] getAmbientParticles(@Nonnull Biome biome) {
        return biome instanceof IAmbienceBiome ? ((IAmbienceBiome)biome).getAmbientParticles() : null;
    }

    @Nullable
    default public SoundEvent getAmbientSound(@Nonnull Biome biome) {
        return biome instanceof IAmbienceBiome ? ((IAmbienceBiome)biome).getAmbientSound() : null;
    }

    @Nullable
    default public ISoundAmbience getRandomAmbientSound(@Nonnull Biome biome) {
        return biome instanceof IAmbienceBiome ? ((IAmbienceBiome)biome).getRandomAmbientSound() : null;
    }

    @Nullable
    default public IDarkSoundAmbience getDarkAmbienceSound(@Nonnull Biome biome) {
        return biome instanceof IAmbienceBiome ? ((IAmbienceBiome)biome).getDarkAmbienceSound() : DarkSoundAmbience.DEFAULT_CAVE;
    }
}

