/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.command.CommandNetherAPI;
import git.jbredwards.nether_api.mod.common.compat.betternether.BetterNetherHandler;
import git.jbredwards.nether_api.mod.common.compat.biomesoplenty.BiomesOPlentyHandler;
import git.jbredwards.nether_api.mod.common.compat.dynamictrees.DynamicTreesHandler;
import git.jbredwards.nether_api.mod.common.compat.journey_into_the_light.JITLHandler;
import git.jbredwards.nether_api.mod.common.compat.nethercraft.NethercraftHandler;
import git.jbredwards.nether_api.mod.common.compat.stygian_end.StygianEndHandler;
import git.jbredwards.nether_api.mod.common.compat.voidislandcontrol.VoidIslandControlHandler;
import git.jbredwards.nether_api.mod.common.network.MessageTeleportFX;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.world.WorldProviderNether;
import git.jbredwards.nether_api.mod.common.world.WorldProviderTheEnd;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="nether_api", name="Nether API", version="1.4.2", dependencies="before:justenoughdimensions@[1.6.0,);after:betternether@[0.1.8.6,);after:biomesoplenty@[7.0.1.2444,);after:journey@1.0.6.11;after:natura@[1.12.2-4.3.2.69,);after:nethercraft@1.0.2;after:netherex@2.2.5;after:perfectspawn@[2.1,);after:stygian@[1.0.4,);after:voidislandcontrol@[1.5.3,);", guiFactory="git.jbredwards.nether_api.mod.client.config.NetherAPIGuiFactory")
public final class NetherAPI {
    @Nonnull
    public static final String MODID = "nether_api";
    @Nonnull
    public static final String NAME = "Nether API";
    @Nonnull
    public static final String VERSION = "1.4.2";
    @Nonnull
    public static final String DEPENDENCIES = "before:justenoughdimensions@[1.6.0,);after:betternether@[0.1.8.6,);after:biomesoplenty@[7.0.1.2444,);after:journey@1.0.6.11;after:natura@[1.12.2-4.3.2.69,);after:nethercraft@1.0.2;after:netherex@2.2.5;after:perfectspawn@[2.1,);after:stygian@[1.0.4,);after:voidislandcontrol@[1.5.3,);";
    public static final boolean isBetterNetherLoaded = Loader.isModLoaded((String)"betternether");
    public static final boolean isBiomesOPlentyLoaded = Loader.isModLoaded((String)"biomesoplenty");
    public static final boolean isDynamicTreesLoaded = Loader.isModLoaded((String)"dynamictrees");
    public static final boolean isJourneyIntoTheLightLoaded = Loader.isModLoaded((String)"journey");
    public static final boolean isNetherHexedKingdomLoaded = Loader.isModLoaded((String)"netherhexedkingdommod");
    public static final boolean isNethercraftLoaded = Loader.isModLoaded((String)"nethercraft");
    public static final boolean isNetherExLoaded = Loader.isModLoaded((String)"netherex");
    public static final boolean isPerfectSpawnLoaded = Loader.isModLoaded((String)"perfectspawn");
    public static final boolean isStygianEndLoaded = Loader.isModLoaded((String)"stygian");
    public static final boolean isVoidIslandControlLoaded = Loader.isModLoaded((String)"voidislandcontrol");
    @Nonnull
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("nether_api");
    public static int messageId = 0;

    @Mod.EventHandler
    static void construct(@Nonnull FMLConstructionEvent event) {
        NetherAPIRegistry.init();
        if (isBetterNetherLoaded) {
            MinecraftForge.EVENT_BUS.register(BetterNetherHandler.class);
        }
        if (isDynamicTreesLoaded) {
            MinecraftForge.EVENT_BUS.register(DynamicTreesHandler.class);
        }
        if (isJourneyIntoTheLightLoaded) {
            MinecraftForge.EVENT_BUS.register(JITLHandler.class);
        }
        if (isNethercraftLoaded) {
            MinecraftForge.EVENT_BUS.register(NethercraftHandler.class);
        }
        if (isVoidIslandControlLoaded) {
            MinecraftForge.EVENT_BUS.register(VoidIslandControlHandler.class);
        }
    }

    @Mod.EventHandler
    static void preInit(@Nonnull FMLPreInitializationEvent event) {
        WRAPPER.registerMessage((IMessageHandler)MessageTeleportFX.Handler.INSTANCE, MessageTeleportFX.class, messageId++, Side.CLIENT);
    }

    @Mod.EventHandler
    static void init(@Nonnull FMLInitializationEvent event) {
        if (isBetterNetherLoaded) {
            BetterNetherHandler.init();
        }
        if (isBiomesOPlentyLoaded) {
            BiomesOPlentyHandler.init();
        }
        if (isJourneyIntoTheLightLoaded) {
            JITLHandler.init();
        }
        if (isNethercraftLoaded) {
            NethercraftHandler.init();
        }
        if (isStygianEndLoaded) {
            StygianEndHandler.init();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    static void initClient(@Nonnull FMLInitializationEvent event) {
        if (isBiomesOPlentyLoaded) {
            BiomesOPlentyHandler.initClient();
        }
        if (isStygianEndLoaded) {
            StygianEndHandler.initClient();
        }
        Optional.ofNullable(Loader.instance().getIndexedModList().get(MODID)).ifPresent(mod -> {
            ReflectionHelper.setPrivateValue(FMLModContainer.class, (Object)((FMLModContainer)mod), (Object)ModContainer.Disableable.NEVER, (String[])new String[]{"disableability"});
            String[] creditsKey = new String[1];
            String[] descKey = new String[1];
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, condition) -> {
                if (condition.test(VanillaResourceType.LANGUAGES) && mod.getMetadata() != null) {
                    mod.getMetadata().credits = I18n.func_135052_a((String)(creditsKey[0] == null ? mod.getMetadata().credits : creditsKey[0]), (Object[])new Object[0]).replace("\\n", "\n");
                    mod.getMetadata().description = I18n.func_135052_a((String)(descKey[0] == null ? mod.getMetadata().description : descKey[0]), (Object[])new Object[0]);
                }
            }));
        });
    }

    @Mod.EventHandler
    static void serverAboutToStart(@Nonnull FMLServerAboutToStartEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DimensionType.NETHER.func_186068_a())) {
            DimensionManager.getProviderType((int)DimensionType.NETHER.func_186068_a()).field_186077_g = WorldProviderNether.class;
        }
        if (DimensionManager.isDimensionRegistered((int)DimensionType.THE_END.func_186068_a())) {
            DimensionManager.getProviderType((int)DimensionType.THE_END.func_186068_a()).field_186077_g = WorldProviderTheEnd.class;
        }
    }

    @Mod.EventHandler
    static void serverStarting(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandNetherAPI());
    }

    @Mod.EventHandler
    static void serverStopping(@Nonnull FMLServerStoppingEvent event) {
        INetherAPIRegistry.REGISTRIES.forEach(INetherAPIRegistry::clear);
    }
}

