/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.betternether;

import biomesoplenty.common.biome.nether.BiomeVisceralHeap;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.compat.betternether.BiomeBetterNether;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.world.BNWorldGenerator;

public final class TransformerBetterNetherGenerator
implements ITransformer {
    public static boolean isEnabled = true;

    void legacyTransformer(@Nonnull ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("generate")) continue;
            int biomeIndex = -1;
            int wzIndex = -1;
            for (LocalVariableNode var : method.localVariables) {
                if (var.name.equals("wz")) {
                    wzIndex = var.index;
                    continue;
                }
                if (!var.name.equals("biome")) continue;
                biomeIndex = var.index;
            }
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("makeBiomeArray")) {
                    if (((MethodInsnNode)insn).desc.startsWith("(L")) {
                        method.instructions.remove(insn.getPrevious());
                    }
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() == 54 && ((VarInsnNode)insn).var == wzIndex) {
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new VarInsnNode(21, wzIndex - 2));
                    list.add((AbstractInsnNode)new VarInsnNode(21, wzIndex));
                    list.add((AbstractInsnNode)this.genHookMethod("getNetherBiome", "(Lnet/minecraft/world/World;II)Lpaulevs/betternether/biomes/NetherBiome;"));
                    list.add((AbstractInsnNode)new VarInsnNode(58, biomeIndex));
                    method.instructions.insert(insn, list);
                    continue;
                }
                if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 126) {
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHeightMethod());
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(5));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(100));
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).name.equals("getBiomeLocal")) continue;
                if (((MethodInsnNode)insn).desc.contains("World")) {
                    method.instructions.remove(insn.getPrevious());
                }
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getNext());
                method.instructions.remove(insn);
                return;
            }
        }
    }

    void continuationTransformer(@Nonnull ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("generate")) continue;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("makeBiomeArray")) {
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() == 16 && ((IntInsnNode)insn).operand == 126) {
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHeightMethod());
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(5));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(100));
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).name.equals("getBiomeFromCache")) continue;
                method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 10));
                method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getNetherBiome", "(II[[Lpaulevs/betternether/biomes/NetherBiome;Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Lpaulevs/betternether/biomes/NetherBiome;"));
                method.instructions.remove(insn);
                return;
            }
        }
    }

    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        if (isEnabled && transformedName.equals("paulevs.betternether.world.BNWorldGenerator")) {
            return this.transform(basicClass, true, classNode -> {
                boolean useLegacyTransformer = false;
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals("smoothChunk")) continue;
                    useLegacyTransformer = true;
                    break;
                }
                if (useLegacyTransformer) {
                    this.legacyTransformer((ClassNode)classNode);
                } else {
                    this.continuationTransformer((ClassNode)classNode);
                }
            });
        }
        if (transformedName.startsWith("paulevs.betternether.biomes.") || transformedName.startsWith("paulevs.betternether.structures.plants.")) {
            return this.transformMethod(basicClass, (MethodNode method) -> true, (MethodNode method, AbstractInsnNode insn) -> {
                if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) {
                    method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                    if (!DEOBFUSCATED) {
                        ((MethodInsnNode)insn).name = "func_180501_a";
                    }
                    ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                }
                return ITransformer.BreakType.CONTINUE;
            });
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nonnull
        private static final NetherBiome VISCERAL_FEATURES = new NetherBiome(BiomeRegister.BIOME_EMPTY_NETHER.getName()){

            public void genCeilObjects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random random) {
                if (BNWorldGenerator.hasEyeGen && random.nextDouble() < NetherAPIConfig.BetterNether.visceralEyeGen && random.nextDouble() * 4.0 + 0.5 < this.getFeatureNoise(pos)) {
                    BNWorldGenerator.eyeGen.generate(world, pos.func_177977_b(), random);
                }
            }
        };

        @Nonnull
        public static NetherBiome getNetherBiome(@Nonnull World world, int wx, int wz) {
            Biome biome = world.func_180494_b(new BlockPos(wx, 0, wz));
            if (biome instanceof BiomeBetterNether) {
                return ((BiomeBetterNether)biome).netherBiome;
            }
            if (NetherAPI.isBiomesOPlentyLoaded && biome instanceof BiomeVisceralHeap) {
                return VISCERAL_FEATURES;
            }
            return BiomeRegister.BIOME_EMPTY_NETHER;
        }

        @Nonnull
        public static NetherBiome getNetherBiome(int x, int z, @Nonnull NetherBiome[][] cache, @Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
            return cache[x][z] == null ? (cache[x][z] = Hooks.getNetherBiome(world, pos.func_177958_n(), pos.func_177952_p())) : cache[x][z];
        }
    }
}

