/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.betternether;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.block.BlockBOPGrass;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import paulevs.betternether.blocks.BlocksRegister;

public final class TransformerBetterNetherPlants
implements ITransformer {
    @Nonnull
    public final Map<String, Info> infoLookup = new HashMap<String, Info>();

    public TransformerBetterNetherPlants() {
        this.infoLookup.put("paulevs.betternether.blocks.BlockBlackApple", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockBlackAppleSeed", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockBlackBush", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c", "canStay"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockEggPlant", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockEyeSeed", new Info("NETHERRACK_PLANT_TYPE", "DOWN").redirect("getSoilEye").targets(DEOBFUSCATED ? "randomTick" : "func_180645_a", DEOBFUSCATED ? "neighborChanged" : "func_189540_a", DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockEyeVine", new Info("NETHERRACK_PLANT_TYPE", "DOWN").redirect("getSoilEye").targets(DEOBFUSCATED ? "neighborChanged" : "func_189540_a"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockInkBush", new Info("NETHER_PLANT_TYPE", "UP").targets("canStay"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockInkBushSeed", new Info("NETHER_PLANT_TYPE", "UP").targets("canStay"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockLucisSpore", new Info("NETHERRACK_PLANT_TYPE", new String[0]).targets("canAttachTo"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockMold", new Info("NETHERRACK_PLANT_TYPE", "UP").redirect("getSoilMoss").targets("canStay"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockNetherGrass", new Info("NETHER_PLANT_TYPE", "UP"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockNetherReed", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockOrangeMushroom", new Info("NETHERRACK_PLANT_TYPE", "UP").redirect("getSoilMoss").targets("canStay"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockStalagnateSeed", new Info("NETHERRACK_PLANT_TYPE", "DOWN", "UP").targets(DEOBFUSCATED ? "grow" : "func_176474_b", DEOBFUSCATED ? "updateTick" : "func_180650_b", DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c", DEOBFUSCATED ? "onBlockPlacedBy" : "func_180633_a"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockStalagnateSeedBottom", new Info("NETHERRACK_PLANT_TYPE", "UP", "DOWN").targets(DEOBFUSCATED ? "grow" : "func_176474_b", DEOBFUSCATED ? "updateTick" : "func_180650_b", DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
        this.infoLookup.put("paulevs.betternether.blocks.BlockWartSeed", new Info("NETHER_PLANT_TYPE", "UP").targets(DEOBFUSCATED ? "canGrow" : "func_176473_a", DEOBFUSCATED ? "canPlaceBlockAt" : "func_176196_c"));
    }

    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        Info info = this.infoLookup.get(transformedName);
        return this.transform(basicClass, classNode -> {
            if (info.type != null) {
                this.transformPlantable((ClassNode)classNode, info.type);
            }
            if (!info.targets.isEmpty()) {
                Object2IntArrayMap indexLookup = new Object2IntArrayMap();
                this.transformMethod((ClassNode)classNode, (MethodNode method) -> info.targets.contains(method.name), (arg_0, arg_1) -> this.lambda$null$2((Object2IntMap)indexLookup, info, arg_0, arg_1));
            }
            if (info.direction.length == 0) {
                this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "canPlaceBlockOnSide" : "func_176198_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    method.instructions.clear();
                    if (method.tryCatchBlocks != null) {
                        method.tryCatchBlocks.clear();
                    }
                    if (method.localVariables != null) {
                        method.localVariables.clear();
                    }
                    if (method.visibleLocalVariableAnnotations != null) {
                        method.visibleLocalVariableAnnotations.clear();
                    }
                    if (method.invisibleLocalVariableAnnotations != null) {
                        method.invisibleLocalVariableAnnotations.clear();
                    }
                    GeneratorAdapter generator = new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc);
                    generator.visitVarInsn(25, 3);
                    generator.visitMethodInsn(182, "net/minecraft/util/EnumFacing", DEOBFUSCATED ? "getAxis" : "func_176740_k", "()Lnet/minecraft/util/EnumFacing$Axis;", false);
                    generator.visitMethodInsn(182, "net/minecraft/util/EnumFacing$Axis", DEOBFUSCATED ? "isHorizontal" : "func_176722_c", "()Z", false);
                    generator.visitVarInsn(25, 0);
                    generator.visitVarInsn(25, 1);
                    generator.visitVarInsn(25, 2);
                    generator.visitVarInsn(25, 3);
                    generator.visitMethodInsn(182, "net/minecraft/util/EnumFacing", DEOBFUSCATED ? "getOpposite" : "func_176734_d", "()Lnet/minecraft/util/EnumFacing;", false);
                    generator.visitMethodInsn(182, "net/minecraft/util/math/BlockPos", DEOBFUSCATED ? "offset" : "func_177972_a", "(Lnet/minecraft/util/EnumFacing;)Lnet/minecraft/util/math/BlockPos;", false);
                    generator.visitVarInsn(25, 3);
                    generator.visitMethodInsn(182, classNode.name, "canAttachTo", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)Z", false);
                    generator.visitInsn(126);
                    generator.returnValue();
                    return ITransformer.BreakType.METHODS;
                });
            }
        });
    }

    private /* synthetic */ ITransformer.BreakType lambda$null$2(Object2IntMap indexLookup, Info info, MethodNode method, AbstractInsnNode insn) {
        int index;
        if (insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getBlockState" : "func_180495_p") && ((index = ((Integer)indexLookup.compute((Object)method.name, (key, value) -> value == null ? 1 : value + 1)).intValue()) != 1 || !method.name.equals(DEOBFUSCATED ? "grow" : "func_176474_b"))) {
            if (info.direction.length != 0) {
                method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/util/EnumFacing", info.direction[index - 1], "Lnet/minecraft/util/EnumFacing;"));
            } else {
                method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
            }
            if (!method.name.equals(DEOBFUSCATED ? "canGrow" : "func_176473_a")) {
                method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            } else {
                method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Blocks", DEOBFUSCATED ? "NETHER_WART" : "field_150388_bm", "Lnet/minecraft/block/Block;"));
                method.instructions.insertBefore(insn, (AbstractInsnNode)new TypeInsnNode(192, "net/minecraftforge/common/IPlantable"));
            }
            method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod(info.redirect, "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraftforge/common/IPlantable;)Lnet/minecraft/block/state/IBlockState;"));
            method.instructions.remove(insn);
            if (index >= info.direction.length) {
                return info.targets.size() == 1 ? ITransformer.BreakType.METHODS : ITransformer.BreakType.INSTRUCTIONS;
            }
        }
        return ITransformer.BreakType.CONTINUE;
    }

    private static final class Info {
        @Nonnull
        final Set<String> targets = new HashSet<String>();
        @Nonnull
        final String[] direction;
        @Nullable
        final String type;
        @Nonnull
        String redirect = "getSoil";

        Info(@Nullable String typeIn, String ... directionIn) {
            this.direction = directionIn;
            this.type = typeIn;
        }

        @Nonnull
        Info redirect(@Nonnull String redirectIn) {
            this.redirect = redirectIn;
            return this;
        }

        @Nonnull
        Info targets(String ... targetsIn) {
            this.targets.addAll(Arrays.asList(targetsIn));
            return this;
        }
    }

    public static final class Hooks {
        @Nonnull
        public static IBlockState getSoil(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
            IBlockState soil = world.func_180495_p(pos);
            if (!soil.func_177230_c().canSustainPlant(soil, world, pos, direction, plantable)) {
                return soil;
            }
            EnumPlantType type = plantable.getPlantType(world, pos.func_177972_a(direction));
            return (type == EnumPlantType.Nether ? Blocks.field_150425_aM : Blocks.field_150424_aL).func_176223_P();
        }

        @Nonnull
        public static IBlockState getSoilEye(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
            IBlockState soil = world.func_180495_p(pos);
            if (NetherAPI.isBiomesOPlentyLoaded && soil.func_177230_c() == BOPBlocks.flesh) {
                return Blocks.field_150424_aL.func_176223_P();
            }
            return soil.func_177230_c().canSustainPlant(soil, world, pos, direction, plantable) ? Blocks.field_150424_aL.func_176223_P() : soil;
        }

        @Nonnull
        public static IBlockState getSoilMoss(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
            IBlockState soil = world.func_180495_p(pos);
            if (soil.func_177230_c() == Blocks.field_150391_bh) {
                return BlocksRegister.BLOCK_NETHER_MYCELIUM.func_176223_P();
            }
            if (NetherAPIConfig.BetterNether.moldOnMyceliumOnly) {
                if (soil.func_177230_c() != BlocksRegister.BLOCK_NETHER_MYCELIUM && NetherAPI.isBiomesOPlentyLoaded && soil.func_177230_c() == BOPBlocks.grass && soil.func_177229_b((IProperty)BlockBOPGrass.VARIANT) == BlockBOPGrass.BOPGrassType.MYCELIAL_NETHERRACK) {
                    return BlocksRegister.BLOCK_NETHER_MYCELIUM.func_176223_P();
                }
                return soil;
            }
            return soil.func_177230_c().canSustainPlant(soil, world, pos, direction, plantable) ? BlocksRegister.BLOCK_NETHER_MYCELIUM.func_176223_P() : soil;
        }
    }
}

