/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.biomesoplenty;

import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerBiomesOPlentyFixes
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "biomesoplenty.common.handler.FogEventHandler": 
            case "zmaster587.advancedRocketry.event.PlanetEventHandler": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("onGetFogColor") || method.name.equals("onRenderFog") || method.name.equals("fogColor"), (MethodNode method, AbstractInsnNode insn) -> {
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/client/event/EntityViewRenderEvent", "getEntity", "()Lnet/minecraft/entity/Entity;", false));
                    list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", DEOBFUSCATED ? "world" : "field_70170_p", "Lnet/minecraft/world/World;"));
                    list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/World", DEOBFUSCATED ? "provider" : "field_73011_w", "Lnet/minecraft/world/WorldProvider;"));
                    list.add((AbstractInsnNode)new TypeInsnNode(193, "git/jbredwards/nether_api/mod/common/world/IFogWorldProvider"));
                    LabelNode label = new LabelNode();
                    list.add((AbstractInsnNode)new JumpInsnNode(153, label));
                    list.add((AbstractInsnNode)new InsnNode(177));
                    list.add((AbstractInsnNode)label);
                    list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                    method.instructions.insert(method.instructions.getFirst(), list);
                    return ITransformer.BreakType.INSTRUCTIONS;
                });
            }
            case "biomesoplenty.common.world.generator.GeneratorBramble": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "generate" : "func_180709_b"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                        if (!DEOBFUSCATED) {
                            ((MethodInsnNode)insn).name = "func_180501_a";
                        }
                        ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "isAirBlock" : "func_175623_d")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("canPlaceLeaves", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"));
                        method.instructions.remove(insn);
                    } else if (insn.getNext().getOpcode() == 58 && ((VarInsnNode)insn.getNext()).var == 5 && insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "offset" : "func_177972_a")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getClampedOffset", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "biomesoplenty.common.world.generator.GeneratorHive": {
                return this.transform(basicClass, classNode -> {
                    this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals("<init>"), (MethodNode method, AbstractInsnNode insn) -> {
                        if (insn.getOpcode() == 181 && ((FieldInsnNode)insn).name.equals("maxRadius")) {
                            method.instructions.insertBefore(insn, (AbstractInsnNode)new IntInsnNode(16, 8));
                            method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "java/lang/Math", "min", "(II)I", false));
                            return ITransformer.BreakType.METHODS;
                        }
                        return ITransformer.BreakType.CONTINUE;
                    });
                    this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "generate" : "func_180709_b"), (MethodNode method, AbstractInsnNode insn) -> {
                        if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_180501_a")) {
                            method.instructions.remove(insn.getPrevious());
                            method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                        }
                        return ITransformer.BreakType.CONTINUE;
                    });
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        public static boolean canPlaceLeaves(@Nonnull World world, @Nonnull BlockPos genPos, @Nonnull BlockPos origin) {
            int minX = origin.func_177958_n() - 8 & 0xFFFFFFF0;
            if (genPos.func_177958_n() < minX || genPos.func_177958_n() > minX + 31) {
                return false;
            }
            int minZ = origin.func_177952_p() - 8 & 0xFFFFFFF0;
            return genPos.func_177952_p() >= minZ && genPos.func_177952_p() <= minZ + 31 && world.func_175623_d(genPos);
        }

        @Nonnull
        public static BlockPos getClampedOffset(@Nonnull BlockPos genPos, @Nonnull EnumFacing offset, @Nonnull BlockPos origin) {
            int minZ;
            int minX;
            int x = genPos.func_177958_n() + offset.func_82601_c();
            if (x < (minX = origin.func_177958_n() - 8 & 0xFFFFFFF0) || x > minX + 31) {
                return genPos;
            }
            int z = genPos.func_177952_p() + offset.func_82599_e();
            return z < (minZ = origin.func_177952_p() - 8 & 0xFFFFFFF0) || z > minZ + 31 ? genPos : genPos.func_177972_a(offset);
        }
    }
}

