/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.hexed;

import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.util.Random;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.template.Template;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerNetherHexedKingdom
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        if (transformedName.startsWith("com.deimoshexxus.netherhexedkingdommod.world.generators.")) {
            String structure = transformedName.substring("com.deimoshexxus.netherhexedkingdommod.world.generators.".length()).replaceFirst("WorldGen", "").replaceFirst("Nether", "");
            return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("generate"), (MethodNode method, AbstractInsnNode insn) -> {
                if (insn.getOpcode() == 183 && ((MethodInsnNode)insn).owner.equals("net/minecraft/util/math/BlockPos") && ((MethodInsnNode)insn).desc.equals("(III)V")) {
                    method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("fixPosition", "(Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;L" + this.genHookClass() + ";I)Lnet/minecraft/util/math/BlockPos;"));
                    switch (structure) {
                        case "BullionTemple": {
                            method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(7));
                            break;
                        }
                        case "LostOutpost": {
                            method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(8));
                            break;
                        }
                        case "TowerOfRedSun": {
                            method.instructions.insert(insn, (AbstractInsnNode)new IntInsnNode(16, 7));
                            break;
                        }
                        case "DamnedPrison": 
                        case "GreedMines": {
                            method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(3));
                            break;
                        }
                        case "IronClad": 
                        case "WretchedLookout": {
                            method.instructions.insert(insn, (AbstractInsnNode)new InsnNode(6));
                            break;
                        }
                        default: {
                            method.instructions.insert(insn, (AbstractInsnNode)new IntInsnNode(16, 8));
                        }
                    }
                    method.instructions.insert(insn, (AbstractInsnNode)this.genHookField(structure, 'L' + this.genHookClass() + ';'));
                    method.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                } else if (transformedName.endsWith("d")) {
                    if (insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "east" : "func_177965_g")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new IntInsnNode(16, 16));
                    } else if (insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "west" : "func_177985_f")) {
                        method.instructions.remove(insn.getPrevious());
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(4));
                    }
                } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "addBlocksToWorld" : "func_186253_b")) {
                    method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, ((MethodInsnNode)insn).owner, DEOBFUSCATED ? "addBlocksToWorld" : "func_189962_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/gen/structure/template/PlacementSettings;I)V", false));
                    method.instructions.insert(insn, (AbstractInsnNode)this.genBlockFlags());
                    method.instructions.remove(insn);
                } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getTemplate" : "func_186237_a")) {
                    method.instructions.insert(insn, (AbstractInsnNode)this.genHookMethod("fixTemplate", "(Lnet/minecraft/world/gen/structure/template/Template;)Lnet/minecraft/world/gen/structure/template/Template;"));
                }
                return ITransformer.BreakType.CONTINUE;
            });
        }
        return basicClass;
    }

    public static enum Hooks {
        BullionTemple(() -> NetherAPIConfig.NHK.bullionTempleMinHeight, () -> NetherAPIConfig.NHK.bullionTempleMaxHeight),
        DamnedPrison(() -> NetherAPIConfig.NHK.damnedPrisonMinHeight, () -> NetherAPIConfig.NHK.damnedPrisonMaxHeight),
        GreedMines(() -> NetherAPIConfig.NHK.greedMinesMinHeight, () -> NetherAPIConfig.NHK.greedMinesMaxHeight),
        IronClad(() -> NetherAPIConfig.NHK.ironCladMinHeight, () -> NetherAPIConfig.NHK.ironCladMaxHeight),
        LostOutpost(() -> NetherAPIConfig.NHK.lostOutpostMinHeight, () -> NetherAPIConfig.NHK.lostOutpostMaxHeight),
        MagmaCubeNest(() -> NetherAPIConfig.NHK.magmaCubeNestMinHeight, () -> NetherAPIConfig.NHK.magmaCubeNestMaxHeight),
        TowerOfRedSun(() -> NetherAPIConfig.NHK.towerOfRedSunMinHeight, () -> NetherAPIConfig.NHK.towerOfRedSunMaxHeight),
        WrathTower(() -> NetherAPIConfig.NHK.wrathTowerMinHeight, () -> NetherAPIConfig.NHK.wrathTowerMaxHeight),
        WretchedLookout(() -> NetherAPIConfig.NHK.wretchedLookoutMinHeight, () -> NetherAPIConfig.NHK.wretchedLookoutMaxHeight);

        @Nonnull
        private final IntSupplier minHeightForGen;
        @Nonnull
        private final IntSupplier maxHeightForGen;

        private Hooks(IntSupplier minHeightIn, IntSupplier maxHeightIn) {
            this.minHeightForGen = minHeightIn;
            this.maxHeightForGen = maxHeightIn;
        }

        public int getMinHeightForGen() {
            return this.minHeightForGen.getAsInt();
        }

        public int getMaxHeightForGen() {
            return this.maxHeightForGen.getAsInt();
        }

        @Nonnull
        public static BlockPos fixPosition(@Nonnull BlockPos pos, @Nonnull Random rand, @Nonnull Hooks settings, int offset) {
            return new BlockPos(pos.func_177958_n() - 8 + offset, MathHelper.func_76136_a((Random)rand, (int)settings.getMinHeightForGen(), (int)settings.getMaxHeightForGen()), pos.func_177952_p() - 8 + offset);
        }

        @Nonnull
        public static Template fixTemplate(@Nonnull Template template) {
            template.field_186271_b.removeIf(info -> info.field_186249_c.func_74779_i("id").isEmpty());
            return template;
        }
    }
}

