/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded.nethercraft;

import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerNethercraftEvents
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "com.legacy.nethercraft.entities.NetherEntityRegistry": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("register") && method.desc.equals("(Ljava/lang/Class;III)V"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 178 && ((FieldInsnNode)insn).name.equals(DEOBFUSCATED ? "HELL" : "field_76778_j")) {
                        ((FieldInsnNode)insn).owner = "git/jbredwards/nether_api/mod/common/compat/nethercraft/NethercraftHandler";
                        ((FieldInsnNode)insn).name = "GLOWING_GROVE";
                        ((FieldInsnNode)insn).desc = "Lgit/jbredwards/nether_api/mod/common/compat/nethercraft/BiomeNethercraft;";
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.legacy.nethercraft.world.NetherGenTree": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "generate" : "func_180709_b"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 17 && ((IntInsnNode)insn).operand == 128) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHeightMethod());
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "setBlockState" : "func_175656_a")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genBlockFlags());
                        if (!DEOBFUSCATED) {
                            ((MethodInsnNode)insn).name = "func_180501_a";
                        }
                        ((MethodInsnNode)insn).desc = "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z";
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.legacy.nethercraft.world.NetherWorldEvent": {
                return this.transform(basicClass, classNode -> classNode.methods.removeIf(method -> method.name.equals("onGenerateLand") || method.name.equals("onNetherDecorated")));
            }
            case "com.legacy.nethercraft.entities.projectile.EntitySlimeEggs": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "onImpact" : "func_70184_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals("nextInt")) {
                        ((JumpInsnNode)insn.getNext()).setOpcode(153);
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("canSpawnSlime", "(Ljava/util/Random;ILnet/minecraft/entity/Entity;)Z"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "com.legacy.nethercraft.entities.hostile.EntityBloodyZombie": 
            case "com.legacy.nethercraft.entities.hostile.EntityDarkZombie": 
            case "com.legacy.nethercraft.entities.hostile.EntityLavaSlime": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals("<init>"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 177) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(4));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", DEOBFUSCATED ? "isImmuneToFire" : "field_70178_ae", "Z"));
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        public static boolean canSpawnSlime(@Nonnull Random rand, int chance, @Nonnull Entity entity) {
            return !entity.field_70170_p.field_72995_K && rand.nextInt(chance) == 0;
        }
    }
}

