/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.structure.INetherAPIStructureEntry;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformerCommandLocate
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "getTabCompletions" : "func_184883_a"), (MethodNode method, AbstractInsnNode insn) -> {
            if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getListOfStringsMatchingLastWord" : "func_71530_a")) {
                method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getStructures", "([Ljava/lang/String;)[Ljava/lang/String;"));
                return ITransformer.BreakType.METHODS;
            }
            return ITransformer.BreakType.CONTINUE;
        });
    }

    public static final class Hooks {
        @Nonnull
        public static String[] getStructures(@Nonnull String[] vanillaStructures) {
            HashSet<String> structures = new HashSet<String>(Arrays.asList(vanillaStructures));
            INetherAPIRegistry.REGISTRIES.forEach(registry -> registry.getStructures().stream().map(INetherAPIStructureEntry::getCommandName).forEach(structures::add));
            return structures.toArray(new String[0]);
        }
    }
}

