/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import git.jbredwards.nether_api.mod.common.world.PlayerSpawnLogic;
import io.netty.util.internal.IntegerHolder;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TransformerPlayerChunkMap
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.server.management.PlayerChunkMap": 
            case "net.minecraft.world.WorldServer": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "tick" : "func_72835_b") || method.name.equals(DEOBFUSCATED ? "createSpawnPosition" : "func_73052_b"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "canRespawnHere" : "func_76567_e")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/nether_api/mod/common/world/PlayerSpawnLogic", "canSpawnInDimension", "(Lnet/minecraft/world/WorldProvider;Lnet/minecraft/entity/player/EntityPlayer;)Z", false));
                        method.instructions.remove(insn);
                        if (transformedName.endsWith("PlayerChunkMap")) {
                            return ITransformer.BreakType.METHODS;
                        }
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "isBonusChestEnabled" : "func_77167_c")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("isBonusChestEnabled", "(Lnet/minecraft/world/WorldSettings;Lnet/minecraft/world/World;)Z"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.server.management.PlayerList": {
                IntegerHolder index = new IntegerHolder();
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "recreatePlayerEntity" : "func_72368_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "canRespawnHere" : "func_76567_e")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/nether_api/mod/common/world/PlayerSpawnLogic", "canSpawnInDimension", "(Lnet/minecraft/world/WorldProvider;Lnet/minecraft/entity/player/EntityPlayer;)Z", false));
                        method.instructions.remove(insn);
                    } else if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "getWorld" : "func_71218_a") && ++index.value == 2) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(87));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 4));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 2));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 3));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("getRespawnDimension", "(Lnet/minecraft/entity/player/EntityPlayerMP;Lnet/minecraft/world/World;IZ)I"));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(54, 2));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(21, 2));
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
            case "net.minecraft.world.gen.ChunkProviderServer": {
                return this.transformMethod(basicClass, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "queueUnload" : "func_189549_a"), (MethodNode method, AbstractInsnNode insn) -> {
                    if (insn.getOpcode() == 182 && ((MethodInsnNode)insn).name.equals(DEOBFUSCATED ? "canDropChunk" : "func_186056_c")) {
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                        method.instructions.insertBefore(insn, (AbstractInsnNode)this.genHookMethod("canDropChunk", "(Lnet/minecraft/world/WorldProvider;IILnet/minecraft/world/gen/ChunkProviderServer;)Z"));
                        method.instructions.remove(insn);
                        return ITransformer.BreakType.METHODS;
                    }
                    return ITransformer.BreakType.CONTINUE;
                });
            }
        }
        return basicClass;
    }

    public static final class Hooks {
        public static boolean canDropChunk(@Nonnull WorldProvider provider, int x, int z, @Nonnull ChunkProviderServer manager) {
            return provider.func_186056_c(x, z) && (!manager.field_73251_h.func_72916_c(x, z) || !PlayerSpawnLogic.canSpawnInDimension(provider, null));
        }

        @Nonnull
        private static OptionalInt findValidDimension(@Nonnull EntityPlayerMP player, @Nonnull boolean[] spawnPointObstructed, @Nonnull Integer[] dimensions, @Nonnull IntPredicate filter) {
            return Arrays.stream(dimensions).mapToInt(Integer::intValue).filter(filter.and(dimension -> {
                boolean isValid;
                BlockPos bedPos = player.getBedLocation(dimension);
                if (bedPos == null) {
                    return false;
                }
                WorldServer world = player.field_71133_b.func_71218_a(dimension);
                boolean bl = isValid = world != null && EntityPlayer.func_180467_a((World)world, (BlockPos)bedPos, (boolean)player.isSpawnForced(dimension)) != null;
                if (!isValid) {
                    spawnPointObstructed[0] = true;
                }
                return isValid;
            })).findFirst();
        }

        public static int getRespawnDimension(@Nonnull EntityPlayerMP player, @Nullable World world, int dimension, boolean conqueredEnd) {
            int defaultDimension;
            boolean canRespawnHere;
            if (player.hasSpawnDimension() && (!conqueredEnd || player.field_71093_bK != player.getSpawnDimension())) {
                return player.getSpawnDimension();
            }
            boolean bl = canRespawnHere = !conqueredEnd && world != null && PlayerSpawnLogic.canSpawnInDimension(world.field_73011_w, (EntityPlayer)player);
            if (canRespawnHere && player.field_71093_bK != 0) {
                defaultDimension = player.field_71093_bK;
            } else {
                int initialDimension = PlayerSpawnLogic.getInitialSpawnDimension(player.func_146103_bH());
                int n = defaultDimension = conqueredEnd && player.field_71093_bK == initialDimension ? 0 : initialDimension;
            }
            if (canRespawnHere || dimension == 0 || dimension == defaultDimension) {
                WorldServer respawnWorld;
                boolean[] spawnPointObstructed = new boolean[1];
                int respawnDimension = (!conqueredEnd && player.func_180470_cg() != null ? Hooks.findValidDimension(player, spawnPointObstructed, new Integer[]{player.field_71093_bK}, id -> true) : OptionalInt.empty()).orElseGet(() -> Hooks.findValidDimension(player, spawnPointObstructed, DimensionManager.getStaticDimensionIDs(), conqueredEnd ? id -> id != player.field_71093_bK : id -> true).orElse(defaultDimension));
                if (spawnPointObstructed[0] && ((respawnWorld = player.field_71133_b.func_71218_a(respawnDimension)) == null && player.getBedLocation(0) == null || player.getBedLocation(respawnDimension) == null)) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(0, 0.0f));
                }
                return respawnDimension;
            }
            return dimension;
        }

        public static int getSpawnDimension(@Nonnull EntityPlayerMP player, int fallback) {
            return player.hasSpawnDimension() ? player.getSpawnDimension() : fallback;
        }

        public static boolean isBonusChestEnabled(@Nonnull WorldSettings settings, @Nonnull World world) {
            return settings.func_77167_c() && world.field_73011_w.getDimension() == 0;
        }
    }
}

