/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.asm.transformers.ITransformer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformerWorldProvider
implements ITransformer {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        return this.transform(basicClass, classNode -> {
            if (!transformedName.equals("net.minecraft.world.WorldProvider")) {
                classNode.methods.removeIf(method -> method.name.equals(DEOBFUSCATED ? "canCoordinateBeSpawn" : "func_76566_a"));
                return;
            }
            this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals(DEOBFUSCATED ? "canCoordinateBeSpawn" : "func_76566_a"), (MethodNode method, AbstractInsnNode insn) -> {
                method.instructions.clear();
                if (method.tryCatchBlocks != null) {
                    method.tryCatchBlocks.clear();
                }
                if (method.localVariables != null) {
                    method.localVariables.clear();
                }
                if (method.visibleLocalVariableAnnotations != null) {
                    method.visibleLocalVariableAnnotations.clear();
                }
                if (method.invisibleLocalVariableAnnotations != null) {
                    method.invisibleLocalVariableAnnotations.clear();
                }
                GeneratorAdapter generator = new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc);
                generator.visitVarInsn(25, 0);
                generator.visitFieldInsn(180, classNode.name, DEOBFUSCATED ? "world" : "field_76579_a", "Lnet/minecraft/world/World;");
                generator.visitVarInsn(21, 1);
                generator.visitVarInsn(21, 2);
                generator.visitMethodInsn(184, this.genHookClass(), "canCoordinateBeSpawn", "(Lnet/minecraft/world/World;II)Z", false);
                generator.visitInsn(172);
                return ITransformer.BreakType.METHODS;
            });
            this.transformMethod((ClassNode)classNode, (MethodNode method) -> method.name.equals("getRandomizedSpawnPoint"), (MethodNode method, AbstractInsnNode insn) -> {
                method.instructions.clear();
                if (method.tryCatchBlocks != null) {
                    method.tryCatchBlocks.clear();
                }
                if (method.localVariables != null) {
                    method.localVariables.clear();
                }
                if (method.visibleLocalVariableAnnotations != null) {
                    method.visibleLocalVariableAnnotations.clear();
                }
                if (method.invisibleLocalVariableAnnotations != null) {
                    method.invisibleLocalVariableAnnotations.clear();
                }
                GeneratorAdapter generator = new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc);
                generator.visitVarInsn(25, 0);
                generator.visitFieldInsn(180, classNode.name, DEOBFUSCATED ? "world" : "field_76579_a", "Lnet/minecraft/world/World;");
                generator.visitMethodInsn(184, this.genHookClass(), "getRandomizedSpawnPoint", "(Lnet/minecraft/world/World;)Lnet/minecraft/util/math/BlockPos;", false);
                generator.visitInsn(176);
                return ITransformer.BreakType.METHODS;
            });
        });
    }

    public static final class Hooks {
        public static boolean canCoordinateBeSpawn(@Nonnull World world, int x, int z) {
            if (world.func_189649_b(x, z) == 0) {
                return false;
            }
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            if (biome.func_185352_i()) {
                return true;
            }
            if (world.field_73011_w.func_76567_e()) {
                return world.func_184141_c(new BlockPos(x, 0, z)).func_177230_c() == Blocks.field_150349_c;
            }
            BlockPos spawnCoord = world.field_73011_w.func_177496_h();
            ChunkCache cache = Hooks.createCache(world, new BlockPos(x, 0, z), 0);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, spawnCoord != null ? spawnCoord.func_177956_o() : world.func_181545_F(), z);
            while (pos.func_177956_o() < world.func_72940_L() - 1 && !Hooks.isBlockGround(world.func_73046_m(), (IBlockAccess)cache, pos.func_189536_c(EnumFacing.UP))) {
            }
            return pos.func_177956_o() < world.func_72940_L() - 1 && Hooks.isBlockGround(world.func_73046_m(), (IBlockAccess)cache, pos);
        }

        @Nonnull
        public static BlockPos getRandomizedSpawnPoint(@Nonnull World world) {
            BlockPos spawnPoint;
            if (NetherAPI.isPerfectSpawnLoaded) {
                return world.func_175694_M();
            }
            BlockPos spawnCoord = world.field_73011_w.func_177496_h();
            if (spawnCoord != null) {
                spawnPoint = spawnCoord;
            } else {
                BlockPos blockPos = spawnPoint = world.field_73011_w.func_177495_o() ? world.field_73011_w.getSpawnPoint() : world.func_175694_M();
            }
            if (world.func_72912_H().func_76077_q() == GameType.ADVENTURE) {
                return spawnPoint;
            }
            int spawnFuzz = world instanceof WorldServer ? world.func_72912_H().func_76067_t().getSpawnFuzz((WorldServer)world, world.func_73046_m()) : 1;
            if ((spawnFuzz = Math.min(spawnFuzz, MathHelper.func_76128_c((double)world.func_175723_af().func_177729_b((double)spawnPoint.func_177958_n(), (double)spawnPoint.func_177952_p())))) > 0) {
                if (spawnFuzz < 2) {
                    spawnFuzz = 2;
                }
                int spawnFuzzHalf = spawnFuzz >> 1;
                if (world.field_73011_w.func_76567_e()) {
                    return world.field_73011_w.func_177495_o() ? spawnPoint : world.func_175672_r(spawnPoint.func_177982_a(spawnFuzzHalf - world.field_73012_v.nextInt(spawnFuzz), 0, spawnFuzzHalf - world.field_73012_v.nextInt(spawnFuzz)));
                }
                ChunkCache cache = Hooks.createCache(world, spawnPoint, spawnFuzzHalf);
                boolean[] checkedPositions = new boolean[spawnFuzz * spawnFuzz];
                int y = spawnCoord != null ? spawnCoord.func_177956_o() : (world.field_73011_w.func_177495_o() ? 32 : world.func_181545_F());
                int spawnAttempts = 1000;
                for (int i = 0; i < 1000; ++i) {
                    int z;
                    int x = world.field_73012_v.nextInt(spawnFuzz);
                    if (checkedPositions[x * spawnFuzz + (z = world.field_73012_v.nextInt(spawnFuzz))]) continue;
                    checkedPositions[x * spawnFuzz + z] = true;
                    if (!world.field_73011_w.func_76566_a(x += spawnPoint.func_177958_n() - spawnFuzzHalf, z += spawnPoint.func_177952_p() - spawnFuzzHalf)) continue;
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
                    while (pos.func_177956_o() < world.func_72940_L() && !Hooks.isBlockGround(world.func_73046_m(), (IBlockAccess)cache, pos.func_189536_c(EnumFacing.UP))) {
                    }
                    return pos.func_189534_c(EnumFacing.DOWN, 2).func_185334_h();
                }
            }
            return spawnPoint;
        }

        @Nonnull
        private static ChunkCache createCache(@Nonnull World world, @Nonnull BlockPos origin, int radius) {
            BlockPos min = new BlockPos(origin.func_177958_n(), 0, origin.func_177952_p());
            BlockPos max = new BlockPos(origin.func_177958_n(), world.func_72940_L(), origin.func_177952_p());
            return new ChunkCache(world, min, max, radius);
        }

        private static boolean isBlockGround(@Nullable MinecraftServer server, @Nonnull IBlockAccess access, @Nonnull BlockPos.MutableBlockPos pos) {
            IBlockState state = access.func_180495_p((BlockPos)pos);
            if (!state.func_185904_a().func_76230_c() || state.func_185904_a().func_76224_d() || state.func_177230_c().isAir(state, access, (BlockPos)pos) || server != null && !state.func_189884_a((Entity)FakePlayerFactory.getMinecraft((WorldServer)server.func_71218_a(0)))) {
                return false;
            }
            IBlockState above = access.func_180495_p((BlockPos)pos.func_189536_c(EnumFacing.UP));
            pos.func_189536_c(EnumFacing.DOWN);
            return !above.func_191058_s() && !state.func_185904_a().func_76224_d() && state.func_185904_a() != Material.field_151581_o;
        }
    }
}

