/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.client.audio;

import git.jbredwards.nether_api.api.audio.IDarkSoundAmbience;
import git.jbredwards.nether_api.api.audio.ISoundAmbience;
import git.jbredwards.nether_api.api.audio.impl.DarkSoundAmbience;
import git.jbredwards.nether_api.api.biome.IAmbienceBiome;
import git.jbredwards.nether_api.api.world.IAmbienceWorldProvider;
import git.jbredwards.nether_api.mod.client.audio.FadingSound;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="nether_api", value={Side.CLIENT})
final class BiomeAmbienceHandler {
    @Nonnull
    static final Map<Biome, FadingSound> activeBiomeAmbientSounds = new HashMap<Biome, FadingSound>();
    @Nonnull
    static final Minecraft mc = Minecraft.func_71410_x();
    @Nullable
    static Biome currentBiome;
    static float caveAmbienceChance;

    BiomeAmbienceHandler() {
    }

    @SubscribeEvent
    static void onPlayerTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !mc.func_147113_T()) {
            if (BiomeAmbienceHandler.mc.field_71439_g != null && BiomeAmbienceHandler.mc.field_71441_e != null) {
                IDarkSoundAmbience caveSound;
                ISoundAmbience ambientSound;
                Vec3d posEyes = BiomeAmbienceHandler.mc.field_71439_g.func_174824_e(mc.func_184121_ak());
                BlockPos pos = new BlockPos(posEyes);
                Biome biome = BiomeAmbienceHandler.mc.field_71441_e.func_180494_b(pos);
                activeBiomeAmbientSounds.values().removeIf(MovingSound::func_147667_k);
                if (biome != currentBiome) {
                    currentBiome = biome;
                    activeBiomeAmbientSounds.values().forEach(FadingSound::fadeOut);
                    ambientSound = IAmbienceWorldProvider.getAmbienceOrFallback((World)BiomeAmbienceHandler.mc.field_71441_e, pos, biome, SoundEvent.class, IAmbienceWorldProvider::getAmbientSound, IAmbienceBiome::getAmbientSound, null);
                    if (ambientSound != null) {
                        activeBiomeAmbientSounds.compute(biome, (arg_0, arg_1) -> BiomeAmbienceHandler.lambda$onPlayerTick$0((SoundEvent)ambientSound, arg_0, arg_1));
                    }
                } else if (activeBiomeAmbientSounds.containsKey(biome) && !mc.func_147118_V().func_147692_c((ISound)activeBiomeAmbientSounds.get(biome))) {
                    currentBiome = null;
                    activeBiomeAmbientSounds.clear();
                }
                ambientSound = IAmbienceWorldProvider.getAmbienceOrFallback((World)BiomeAmbienceHandler.mc.field_71441_e, pos, biome, ISoundAmbience.class, IAmbienceWorldProvider::getRandomAmbientSound, IAmbienceBiome::getRandomAmbientSound, null);
                if (ambientSound != null && Math.random() < ambientSound.getChancePerTick()) {
                    PositionedSoundRecord sound = new PositionedSoundRecord(ambientSound.getSoundEvent().func_187503_a(), SoundCategory.AMBIENT, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
                    mc.func_147118_V().func_147682_a((ISound)sound);
                }
                if ((caveSound = (IDarkSoundAmbience)IAmbienceWorldProvider.getAmbienceOrFallback((World)BiomeAmbienceHandler.mc.field_71441_e, pos, biome, IDarkSoundAmbience.class, IAmbienceWorldProvider::getDarkAmbienceSound, IAmbienceBiome::getDarkAmbienceSound, DarkSoundAmbience.DEFAULT_CAVE)) != null) {
                    double searchZ;
                    double searchY;
                    double searchX = posEyes.field_72450_a + (double)MathHelper.func_76136_a((Random)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au(), (int)(-caveSound.getLightSearchRadius()), (int)caveSound.getLightSearchRadius());
                    BlockPos searchPos = new BlockPos(searchX, searchY = posEyes.field_72448_b + (double)MathHelper.func_76136_a((Random)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au(), (int)(-caveSound.getLightSearchRadius()), (int)caveSound.getLightSearchRadius()), searchZ = posEyes.field_72449_c + (double)MathHelper.func_76136_a((Random)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au(), (int)(-caveSound.getLightSearchRadius()), (int)caveSound.getLightSearchRadius()));
                    int skyLight = BiomeAmbienceHandler.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, searchPos);
                    if ((caveAmbienceChance = (float)((double)caveAmbienceChance - (skyLight > 0 ? (double)skyLight * 0.001 / 15.0 : (double)(BiomeAmbienceHandler.mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, searchPos) - 1) * caveSound.getChancePerTick()))) < 1.0f) {
                        caveAmbienceChance = Math.max(caveAmbienceChance, 0.0f);
                    } else {
                        double offsetX = searchX - posEyes.field_72450_a;
                        double offsetY = searchY - posEyes.field_72448_b;
                        double offsetZ = searchZ - posEyes.field_72449_c;
                        double offset = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
                        double soundOffset = offset * (offset + caveSound.getSoundOffset());
                        float x = (float)(posEyes.field_72450_a + offsetX / soundOffset);
                        float y = (float)(posEyes.field_72448_b + offsetY / soundOffset);
                        float z = (float)(posEyes.field_72449_c + offsetZ / soundOffset);
                        PositionedSoundRecord sound = new PositionedSoundRecord(caveSound.getSoundEvent().func_187503_a(), SoundCategory.AMBIENT, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, x, y, z);
                        mc.func_147118_V().func_147682_a((ISound)sound);
                        caveAmbienceChance = 0.0f;
                    }
                }
            } else {
                activeBiomeAmbientSounds.clear();
                caveAmbienceChance = 0.0f;
                currentBiome = null;
            }
        }
    }

    private static /* synthetic */ FadingSound lambda$onPlayerTick$0(SoundEvent ambientSound, Biome biomeIn, FadingSound sound) {
        if (sound == null) {
            sound = new FadingSound(BiomeAmbienceHandler.mc.field_71439_g, ambientSound, SoundCategory.AMBIENT);
            mc.func_147118_V().func_147682_a((ISound)sound);
        }
        sound.fadeIn();
        return sound;
    }
}

