/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common;

import git.jbredwards.nether_api.api.event.NetherAPIRegistryEvent;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.compat.betternether.BetterNetherHandler;
import git.jbredwards.nether_api.mod.common.compat.biomesoplenty.BiomesOPlentyHandler;
import git.jbredwards.nether_api.mod.common.compat.journey_into_the_light.JITLHandler;
import git.jbredwards.nether_api.mod.common.compat.nethercraft.NethercraftHandler;
import git.jbredwards.nether_api.mod.common.compat.netherex.NetherExHandler;
import git.jbredwards.nether_api.mod.common.compat.stygian_end.StygianEndHandler;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import git.jbredwards.nether_api.mod.common.world.PlayerSpawnLogic;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockTorch;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="nether_api")
final class EventHandler {
    EventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void registerHardcodedEnd(@Nonnull NetherAPIRegistryEvent.End event) {
        if (NetherAPI.isStygianEndLoaded) {
            StygianEndHandler.registerBiomes(event.registry);
        }
        event.registry.registerBiome(Biomes.field_76779_k, NetherAPIConfig.endWeight);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void registerHardcodedNether(@Nonnull NetherAPIRegistryEvent.Nether event) {
        if (NetherAPI.isBetterNetherLoaded) {
            BetterNetherHandler.registerBiomes(event.registry);
        }
        if (NetherAPI.isBiomesOPlentyLoaded) {
            BiomesOPlentyHandler.registerBiomes(event.registry, event.world);
        }
        if (NetherAPI.isJourneyIntoTheLightLoaded) {
            JITLHandler.registerBiomes(event.registry);
        }
        if (NetherAPI.isNethercraftLoaded) {
            NethercraftHandler.registerBiomes(event.registry);
        }
        if (NetherAPI.isNetherExLoaded) {
            NetherExHandler.registerBiomes(event.registry, event.world);
        }
        event.registry.registerBiome(Biomes.field_76778_j, NetherAPIConfig.hellWeight);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void handleDragonResistantBlocks(@Nonnull LivingDestroyBlockEvent event) {
        if (event.getEntity() instanceof EntityDragon) {
            if (event.getState().func_177230_c() instanceof BlockTorch) {
                event.setCanceled(true);
            } else {
                World world = event.getEntity().func_130014_f_();
                BlockPos pos = event.getPos();
                Explosion explosion = new Explosion(world, event.getEntity(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5f, false, true);
                if (event.getEntity().func_180428_a(explosion, world, pos, event.getState()) >= 1200.0f) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void handleRespawnWorldData(@Nonnull WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && PlayerSpawnLogic.canSpawnInDimension(event.getWorld().field_73011_w, null)) {
            System.out.println("Initializing level " + event.getWorld().field_73011_w.getDimension() + "...");
            event.getWorld().func_72963_a(new WorldSettings(event.getWorld().func_72912_H()));
        }
    }
}

