/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.command;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.structure.INetherAPIStructureEntry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.TextTable;

public class CommandListInfo
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "list";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.nether_api." + this.func_71517_b() + ".usage";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandListInfo.func_71530_a((String[])args, (String[])new String[]{"biomes", "structures"});
        }
        if (args.length != 2) {
            return Collections.emptyList();
        }
        return CommandListInfo.func_175762_a((String[])args, (Collection)INetherAPIRegistry.REGISTRIES.stream().map(INetherAPIRegistry::getRegistryName).collect(Collectors.toSet()));
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        String type;
        String string = type = args.length < 1 ? null : args[0];
        if (type != null && !type.equals("biomes") && !type.equals("structures")) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        ResourceLocation registry = args.length < 2 ? null : new ResourceLocation(args[1]);
        INetherAPIRegistry[] registries = (INetherAPIRegistry[])INetherAPIRegistry.REGISTRIES.stream().filter(registry == null ? reg -> true : reg -> reg.getRegistryName().equals((Object)registry)).sorted(Comparator.comparing(INetherAPIRegistry::getRegistryName)).toArray(INetherAPIRegistry[]::new);
        if (registries.length == 0) {
            throw new CommandException("commands.nether_api." + this.func_71517_b() + ".fail", new Object[]{String.valueOf(registry)});
        }
        CommandListInfo.printInfo(sender, type, registries);
    }

    protected static void printInfo(@Nonnull ICommandSender sender, @Nullable String type, @Nonnull INetherAPIRegistry[] registries) {
        TextTable table;
        if (type == null || type.equals("biomes")) {
            table = new TextTable(Arrays.asList(TextTable.column((String)"Registry"), TextTable.column((String)"Biome"), TextTable.column((String)"Weight")));
            for (INetherAPIRegistry iNetherAPIRegistry : registries) {
                iNetherAPIRegistry.getBiomeEntries().stream().filter(entry -> entry.biome.getRegistryName() != null).sorted(Comparator.comparing(entry -> entry.biome.getRegistryName())).forEach(entry -> table.add(new Object[]{registry.getRegistryName(), entry.biome.getRegistryName(), entry.field_76292_a}));
            }
            for (String string : table.build("\n").split("\n")) {
                if (string.isEmpty()) continue;
                sender.func_145747_a((ITextComponent)new TextComponentString(string));
            }
        }
        if (type == null || type.equals("structures")) {
            table = new TextTable(Arrays.asList(TextTable.column((String)"Registry"), TextTable.column((String)"Structure")));
            for (INetherAPIRegistry iNetherAPIRegistry : registries) {
                iNetherAPIRegistry.getStructures().stream().sorted(Comparator.comparing(INetherAPIStructureEntry::getCommandName)).forEach(entry -> table.add(new Object[]{registry.getRegistryName(), entry.getCommandName()}));
            }
            for (String string : table.build("\n").split("\n")) {
                if (string.isEmpty()) continue;
                sender.func_145747_a((ITextComponent)new TextComponentString(string));
            }
        }
    }
}

