/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.betternether;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.compat.betternether.BiomeBetterNether;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.config.ConfigLoader;
import paulevs.betternether.entities.EntityFirefly;

public final class BetterNetherHandler {
    @Nonnull
    static final Set<NetherBiome> GEN_BIOMES = new HashSet<NetherBiome>();
    @Nonnull
    static final Map<NetherBiome, BiomeBetterNether> BIOME_LOOKUP = new HashMap<NetherBiome, BiomeBetterNether>();

    public static boolean isModern() {
        return WeightedRandom.Item.class.isAssignableFrom(NetherBiome.class);
    }

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        GEN_BIOMES.forEach(netherBiome -> {
            BiomeBetterNether biome = BIOME_LOOKUP.get(netherBiome);
            registry.registerBiome((Biome)biome, BetterNetherHandler.getWeight(biome));
        });
    }

    @Nonnull
    public static BiomeBetterNether getBiomeFromLookup(@Nonnull NetherBiome netherBiome) {
        BiomeBetterNether biome = BIOME_LOOKUP.get(netherBiome);
        if (biome != null) {
            return biome;
        }
        throw new IllegalStateException("No Biome found for BetterNether: {" + netherBiome.getName() + '}');
    }

    public static int getWeight(@Nonnull BiomeBetterNether biome) {
        if (biome.cachedWeight == -1) {
            biome.cachedWeight = BetterNetherHandler.isModern() ? (ConfigLoader.mustInitBiome((NetherBiome)biome.netherBiome) ? biome.netherBiome.field_76292_a : 0) : 1;
        }
        return biome.cachedWeight;
    }

    @SubscribeEvent
    static void registerBiomes(@Nonnull RegistryEvent.Register<Biome> event) {
        ObjIntConsumer<NetherBiome> registerAction = (netherBiome, netherBiomeId) -> {
            if (netherBiome == null) {
                return;
            }
            BiomeBetterNether biome = new BiomeBetterNether((NetherBiome)netherBiome, netherBiomeId);
            event.getRegistry().register((IForgeRegistryEntry)biome);
            BIOME_LOOKUP.put((NetherBiome)netherBiome, biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        };
        if (BiomeRegister.BIOME_GRAVEL_DESERT != null) {
            GEN_BIOMES.add(BiomeRegister.BIOME_GRAVEL_DESERT);
        }
        if (BiomeRegister.BIOME_NETHER_JUNGLE != null) {
            GEN_BIOMES.add(BiomeRegister.BIOME_NETHER_JUNGLE);
        }
        if (BiomeRegister.BIOME_WART_FOREST != null) {
            GEN_BIOMES.add(BiomeRegister.BIOME_WART_FOREST);
        }
        if (BiomeRegister.BIOME_GRASSLANDS != null) {
            GEN_BIOMES.add(BiomeRegister.BIOME_GRASSLANDS);
        }
        if (BiomeRegister.BIOME_MUSHROOM_FOREST != null) {
            GEN_BIOMES.add(BiomeRegister.BIOME_MUSHROOM_FOREST);
        }
        registerAction.accept(BiomeRegister.BIOME_EMPTY_NETHER, 0);
        registerAction.accept(BiomeRegister.BIOME_GRAVEL_DESERT, 1);
        registerAction.accept(BiomeRegister.BIOME_NETHER_JUNGLE, 2);
        registerAction.accept(BiomeRegister.BIOME_WART_FOREST, 3);
        registerAction.accept(BiomeRegister.BIOME_GRASSLANDS, 4);
        registerAction.accept(BiomeRegister.BIOME_MUSHROOM_FOREST, 5);
        registerAction.accept(BiomeRegister.BIOME_MUSHROOM_FOREST_EDGE, 6);
        registerAction.accept(BiomeRegister.BIOME_WART_FOREST_EDGE, 7);
        registerAction.accept(BiomeRegister.BIOME_BONE_REEF, 8);
        registerAction.accept(BiomeRegister.BIOME_POOR_GRASSLANDS, 9);
    }

    public static void init() {
        if (BetterNetherHandler.isModern()) {
            ((Set)ObfuscationReflectionHelper.getPrivateValue(ConfigLoader.class, null, (String)"NETHER_TERRAIN")).add(Blocks.field_150424_aL);
        }
        Biomes.field_76778_j.func_76747_a(EnumCreatureType.AMBIENT).removeIf(entry -> entry.field_76300_b == EntityFirefly.class);
        if (BiomeRegister.BIOME_GRASSLANDS != null) {
            EntityRegistry.addSpawn(EntityFirefly.class, (int)100, (int)5, (int)10, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_GRASSLANDS)});
        }
        if (BiomeRegister.BIOME_NETHER_JUNGLE != null) {
            EntityRegistry.addSpawn(EntityFirefly.class, (int)100, (int)5, (int)10, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_NETHER_JUNGLE)});
        }
        if (BiomeRegister.BIOME_GRAVEL_DESERT != null) {
            BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_GRAVEL_DESERT).func_76747_a(EnumCreatureType.MONSTER).removeIf(entry -> EntityGhast.class.isAssignableFrom(entry.field_76300_b));
        }
    }
}

