/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.dynamictrees.block;

import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import git.jbredwards.nether_api.api.util.PlantUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class AbstractBlockRooty
extends BlockRooty {
    @Nonnull
    private static final BlockPos[] searchPattern = (BlockPos[])ReflectionHelper.getPrivateValue(MimicProperty.class, null, (String[])new String[]{"searchPattern"});

    protected AbstractBlockRooty(@Nonnull String name, @Nonnull Material material, boolean isTileEntity) {
        super(name, material, isTileEntity);
    }

    @Nonnull
    public abstract EnumPlantType getSoilType();

    @Nonnull
    protected abstract Block getFallbackMimic();

    @Nonnull
    protected IBlockState getFallbackMimic(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        return this.getFallbackMimic().func_176223_P();
    }

    @Nonnull
    public IBlockState getMimic(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        IPlantable plantable = PlantUtils.createPlantable(this.getSoilType());
        for (BlockPos toAdd : searchPattern) {
            BlockPos offset = pos.func_177971_a((Vec3i)toAdd);
            IBlockState state = access.func_180495_p(offset);
            if (state.func_177230_c().hasTileEntity(state) || state.func_177230_c() instanceof MimicProperty.IMimic || !state.func_177230_c().canSustainPlant(state, access, offset, EnumFacing.UP, plantable)) continue;
            return state;
        }
        return this.getFallbackMimic(access, pos);
    }

    @Nonnull
    public IBlockState getDecayBlockState(@Nonnull IBlockAccess access, @Nonnull BlockPos pos) {
        return this.getMimic(access, pos);
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState state, @Nonnull Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getFallbackMimic());
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing direction, @Nonnull IPlantable plantable) {
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        IBlockState mimic = this.getMimic(world, pos);
        return mimic.func_177230_c().canSustainPlant(mimic, world, pos, direction, plantable);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState mimic = this.getMimic((IBlockAccess)world, pos);
        return mimic.func_177230_c().getPickBlock(mimic, target, world, pos, player);
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        IBlockState mimic = this.getMimic((IBlockAccess)worldIn, pos);
        return mimic.func_177230_c().func_185473_a(worldIn, pos, mimic);
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        IBlockState mimic = this.getMimic((IBlockAccess)world, pos);
        return mimic.func_177230_c().getSoundType(mimic, world, pos, entity);
    }

    @Nonnull
    public SoundType func_185467_w() {
        return this.getFallbackMimic().func_185467_w();
    }
}

