/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.journey_into_the_light;

import git.jbredwards.nether_api.api.biome.INetherAPIBiomeProvider;
import git.jbredwards.nether_api.mod.common.compat.journey_into_the_light.JITLHandler;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.journey.dimension.nether.biomes.NetherBiome;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHell;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class BiomeJITL
extends BiomeHell
implements INetherAPIBiomeProvider {
    @Nonnull
    static final Field SUBBIOMES_FIELD = ObfuscationReflectionHelper.findField(NetherBiome.class, (String)"subbiomes");
    @Nonnull
    public final Class<? extends NetherBiome> netherBiomeClass;
    @Nullable
    public NetherBiome netherBiome;

    BiomeJITL(@Nonnull Class<? extends NetherBiome> netherBiomeClassIn, @Nonnull String nameIn) {
        super(new Biome.BiomeProperties(nameIn).func_185410_a(2.0f).func_185395_b(0.0f).func_185396_a());
        this.setRegistryName("nether_api", "journey_into_the_light_" + netherBiomeClassIn.getSimpleName());
        this.netherBiomeClass = netherBiomeClassIn;
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getEdgeBiomes(int neighborBiomeId) {
        if (this.netherBiome == null) {
            throw new IllegalStateException("Attempted to generate unregistered JITL biome: {" + this.netherBiomeClass.getSimpleName() + '}');
        }
        NetherBiome edge = this.netherBiome.getEdge();
        if (edge == this.netherBiome) {
            return Collections.emptyList();
        }
        Biome neighborBiome = Biome.func_185357_a((int)neighborBiomeId);
        if (neighborBiome == this) {
            return Collections.emptyList();
        }
        for (BiomeManager.BiomeEntry entry : this.getSubBiomes()) {
            if (entry.biome != neighborBiome) continue;
            return Collections.emptyList();
        }
        return Collections.singletonList(new BiomeManager.BiomeEntry((Biome)JITLHandler.getBiomeFromLookup(edge), 1));
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getSubBiomes() {
        if (this.netherBiome == null) {
            throw new IllegalStateException("Attempted to generate unregistered JITL biome: {" + this.netherBiomeClass.getSimpleName() + '}');
        }
        return Collections.unmodifiableList(BiomeJITL.getSubNetherBiomes(this.netherBiome).stream().map(biome -> new BiomeManager.BiomeEntry((Biome)JITLHandler.getBiomeFromLookup(biome), 1)).collect(Collectors.toList()));
    }

    @Nonnull
    public static List<NetherBiome> getSubNetherBiomes(@Nonnull NetherBiome netherBiome) {
        try {
            return (List)SUBBIOMES_FIELD.get(netherBiome);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

