/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.justenoughdimensions;

import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.util.ClientUtils;
import fi.dy.masa.justenoughdimensions.util.world.VoidTeleport;
import fi.dy.masa.justenoughdimensions.util.world.WorldInfoUtils;
import fi.dy.masa.justenoughdimensions.util.world.WorldUtils;
import fi.dy.masa.justenoughdimensions.world.IWorldProviderJED;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import fi.dy.masa.justenoughdimensions.world.WorldProviderJED;
import git.jbredwards.nether_api.api.event.NetherAPIFogColorEvent;
import git.jbredwards.nether_api.mod.common.world.WorldProviderNether;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class JEDWorldProviderNether
extends WorldProviderNether
implements IWorldProviderJED {
    @Nullable
    private VoidTeleport.VoidTeleportData skyTeleport;
    @Nullable
    private VoidTeleport.VoidTeleportData voidTeleport;
    private JEDWorldProperties properties;
    private int teleportCounter;
    private boolean worldInfoSet;
    private boolean shouldSkipSpawnSearch;

    public boolean getWorldInfoHasBeenSet() {
        return this.worldInfoSet;
    }

    public boolean getShouldSkipSpawnSearch() {
        return this.shouldSkipSpawnSearch;
    }

    @Override
    public void setDimension(int dim) {
        super.setDimension(dim);
        this.properties = JEDWorldProperties.getOrCreateProperties((int)dim);
        if (this.field_76579_a != null && !this.getWorldInfoHasBeenSet()) {
            BlockPos oldSpawnPoint = this.getSpawnPoint();
            WorldInfoUtils.loadAndSetCustomWorldInfo((World)this.field_76579_a);
            this.worldInfoSet = true;
            boolean bl = this.shouldSkipSpawnSearch = !oldSpawnPoint.equals((Object)this.getSpawnPoint());
            if (this.properties.getHasSkyLight() != null) {
                this.field_191067_f = this.properties.getHasSkyLight();
            }
            this.skyTeleport = VoidTeleport.VoidTeleportData.fromJson((JsonObject)this.properties.getNestedObject("sky_teleport"), (int)dim);
            this.voidTeleport = VoidTeleport.VoidTeleportData.fromJson((JsonObject)this.properties.getNestedObject("void_teleport"), (int)dim);
        }
    }

    @Override
    @Nonnull
    public IChunkGenerator func_186060_c() {
        IChunkGenerator customGenerator = WorldProviderJED.createChunkGeneratorInstance((World)this.field_76579_a, (WorldProvider)this);
        return customGenerator != null ? customGenerator : super.func_186060_c();
    }

    public void func_186059_r() {
        super.func_186059_r();
        if (++this.teleportCounter >= this.properties.getVoidTeleportInterval()) {
            VoidTeleport.tryVoidTeleportEntities((World)this.field_76579_a, (VoidTeleport.VoidTeleportData)this.voidTeleport, (VoidTeleport.VoidTeleportData)this.skyTeleport);
            this.teleportCounter = 0;
        }
    }

    public void setJEDProperties(@Nonnull JEDWorldProperties propertiesIn) {
        ClientUtils.setRenderersFrom((WorldProvider)this, (JsonObject)propertiesIn.getFullJEDProperties());
        this.properties = propertiesIn;
    }

    @Nonnull
    public WorldProvider.WorldSleepResult canSleepAt(@Nonnull EntityPlayer player, @Nonnull BlockPos pos) {
        WorldProvider.WorldSleepResult val = this.properties.canSleepHere();
        return val != null ? val : super.canSleepAt(player, pos);
    }

    public boolean func_76567_e() {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.canRespawnHere(), (boolean)super.func_76567_e());
    }

    public int getRespawnDimension(@Nonnull EntityPlayerMP player) {
        if (this.properties.getRespawnDimension() != null) {
            return this.properties.getRespawnDimension();
        }
        return this.func_76567_e() ? this.getDimension() : 0;
    }

    @Nonnull
    public float[] func_177497_p() {
        return this.properties.getCustomLightBrightnessTable() != null ? this.properties.getCustomLightBrightnessTable() : super.func_177497_p();
    }

    public int func_76559_b(long worldTime) {
        long cycleLength = this.properties.getDayLength() + this.properties.getNightLength();
        return (int)(worldTime / cycleLength % 8L + 8L) % 8;
    }

    public void setWorldTime(long time) {
        super.setWorldTime(WorldProviderJED.getNewWorldTime((long)time, (long)this.getWorldTime(), (JEDWorldProperties)this.properties));
    }

    public void resetRainAndThunder() {
        if (!this.properties.getDontAdvanceWeatherWhenSleeping()) {
            super.resetRainAndThunder();
        }
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        if (this.properties.getUseCustomDayCycle()) {
            return WorldProviderJED.calculateCelestialAngle((World)this.field_76579_a, (JEDWorldProperties)this.properties, (int)(this.properties.getDayLength() + this.properties.getNightLength()), (long)worldTime, (float)partialTicks);
        }
        return this.properties.getUseCustomCelestialAngleRange() ? WorldProviderJED.getCustomCelestialAngleValue((World)this.field_76579_a, (JEDWorldProperties)this.properties, (int)(this.properties.getDayLength() + this.properties.getNightLength()), (long)worldTime, (float)partialTicks) : 0.5f;
    }

    public void setAllowedSpawnTypes(boolean allowHostileIn, boolean allowPeacefulIn) {
        boolean allowHostile = this.field_76579_a.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL;
        boolean allowPeaceful = allowPeacefulIn;
        JEDWorldProperties props = JEDWorldProperties.getPropertiesIfExists((int)this.getDimension());
        if (props != null) {
            Boolean hostiles = props.canSpawnHostiles();
            Boolean peaceful = props.canSpawnPeacefulMobs();
            if (hostiles != null) {
                allowHostile = hostiles;
            }
            if (peaceful != null) {
                allowPeaceful = peaceful;
            }
        }
        super.setAllowedSpawnTypes(allowHostile, allowPeaceful);
    }

    public boolean func_76566_a(int x, int z) {
        return Boolean.TRUE.equals(this.properties.ignoreSpawnSuitability()) || super.func_76566_a(x, z);
    }

    public boolean canDoLightning(@Nonnull Chunk chunk) {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.canDoLightning(), (boolean)super.canDoLightning(chunk));
    }

    public boolean canDoRainSnowIce(@Nonnull Chunk chunk) {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.canDoRainSnowIce(), (boolean)super.canDoRainSnowIce(chunk));
    }

    public boolean canBlockFreeze(@Nonnull BlockPos pos, boolean byWater) {
        Boolean val = this.properties.canDoRainSnowIce();
        return val != null ? val.booleanValue() && WorldUtils.canBlockFreeze((World)this.field_76579_a, (BlockPos)pos, (boolean)byWater) : super.canBlockFreeze(pos, byWater);
    }

    public boolean canSnowAt(@Nonnull BlockPos pos, boolean checkLight) {
        Boolean val = this.properties.canDoRainSnowIce();
        return val != null ? val.booleanValue() && WorldUtils.canSnowAt((World)this.field_76579_a, (BlockPos)pos) : super.canSnowAt(pos, checkLight);
    }

    public boolean func_177500_n() {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.doesWaterVaporize(), (boolean)super.func_177500_n());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return this.properties.getHasPerBiomeFog() ? this.properties.doesBiomeHaveFog(this.field_76579_a.func_180494_b(new BlockPos(x, 0, z))) : WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.getHasXZFog(), (boolean)super.func_76568_b(x, z));
    }

    public boolean func_76569_d() {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.isSurfaceWorld(), (boolean)super.func_76569_d());
    }

    public int func_76557_i() {
        return WorldProviderJED.getIntegerOrDefault((Integer)this.properties.getAverageGroundLevel(), (int)super.func_76557_i());
    }

    public double getHorizon() {
        return WorldProviderJED.getDoubleOrDefault((Double)this.properties.getHorizon(), (double)super.getHorizon());
    }

    public double getMovementFactor() {
        return WorldProviderJED.getDoubleOrDefault((Double)this.properties.getMovementFactor(), (double)super.getMovementFactor());
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        return WorldProviderJED.getFloatOrDefault((Float)this.properties.getSunBrightness(), (float)super.getSunBrightness(partialTicks));
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightnessFactor(float partialTicks) {
        return WorldProviderJED.getFloatOrDefault((Float)this.properties.getSunBrightnessFactor(), (float)super.getSunBrightnessFactor(partialTicks));
    }

    public boolean shouldClientCheckLighting() {
        return WorldProviderJED.getBooleanOrDefault((Boolean)this.properties.shouldClientCheckLight(), (boolean)super.shouldClientCheckLighting());
    }

    public boolean shouldMapSpin(@Nonnull String entity, double x, double z, double rotation) {
        return !this.func_76569_d();
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        MusicTicker.MusicType music = ClientUtils.getMusicTypeFromProperties((JEDWorldProperties)this.properties);
        return music != null ? music : super.getMusicType();
    }

    @Nonnull
    public BlockPos func_177496_h() {
        return this.field_76579_a.func_175694_M();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return this.properties.getCloudHeight();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(@Nonnull Entity cameraEntity, float partialTicks) {
        Vec3d base = super.getSkyColor(cameraEntity, partialTicks);
        Vec3d skyColor = this.properties.getSkyColor();
        return skyColor != null ? new Vec3d(base.field_72450_a * skyColor.field_72450_a, base.field_72448_b * skyColor.field_72448_b, base.field_72449_c * skyColor.field_72449_c) : base;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        Vec3d base = super.getCloudColor(partialTicks);
        Vec3d cloudColor = this.properties.getCloudColor();
        return cloudColor != null ? new Vec3d(base.field_72450_a * cloudColor.field_72450_a, base.field_72448_b * cloudColor.field_72448_b, base.field_72449_c * cloudColor.field_72449_c) : base;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        Vec3d fogColor = this.properties.getFogColor();
        if (fogColor != null) {
            return this.getFogColor(this.field_76579_a, celestialAngle, partialTicks, fogColor.field_72450_a, fogColor.field_72448_b, fogColor.field_72449_c, NetherAPIFogColorEvent.Nether::new).func_186678_a(MathHelper.func_151237_a((double)(Math.cos((double)celestialAngle * Math.PI * 2.0) * 2.0 + 0.5), (double)0.0, (double)1.0) * 0.94 + 0.06);
        }
        return super.func_76562_b(celestialAngle, partialTicks);
    }
}

