/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.nethercraft;

import com.legacy.nethercraft.blocks.BlocksNether;
import com.legacy.nethercraft.world.NetherGenReeds;
import com.legacy.nethercraft.world.NetherGenTree;
import git.jbredwards.nether_api.api.biome.INetherBiome;
import git.jbredwards.nether_api.api.block.INetherCarvable;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBush;

public final class BiomeNethercraft
extends BiomeHell
implements INetherBiome,
INetherCarvable {
    public static int minTreeTries = 35;
    public static int maxTreeTries = 39;
    public static int reedTries = 7;
    public static int reedChance = 10;
    public static int mushroomTries = 3;
    public static int purpleMushroomChance = 4;
    public static int greenMushroomChance = 8;

    BiomeNethercraft() {
        super(new Biome.BiomeProperties("Glowing Grove").func_185410_a(2.0f).func_185395_b(0.0f).func_185396_a());
        this.setRegistryName("nether_api", "nethercraft_glowing_grove");
        this.field_76752_A = BlocksNether.nether_dirt.func_176223_P();
    }

    @Override
    public void buildSurface(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, @Nonnull ChunkPrimer primer, int x, int z, double[] soulSandNoise, double[] gravelNoise, double[] depthBuffer, double terrainNoise) {
        boolean soulSand = soulSandNoise[x << 4 | z] + chunkGenerator.getRand().nextDouble() * 0.2 > 0.0;
        boolean gravel = gravelNoise[x << 4 | z] + chunkGenerator.getRand().nextDouble() * 0.2 > 0.0;
        int depth = (int)(depthBuffer[x << 4 | z] / 3.0 + 3.0 + chunkGenerator.getRand().nextDouble() * 0.25);
        IBlockState filler = this.field_76752_A;
        int depthRemaining = -1;
        for (int y = chunkGenerator.getWorld().func_72940_L() - 1; y >= 0; --y) {
            if (y >= chunkGenerator.getWorld().func_72940_L() - 1 - chunkGenerator.getRand().nextInt(5) || y <= chunkGenerator.getRand().nextInt(5)) continue;
            if (primer.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150424_aL) {
                if (depthRemaining == -1) {
                    if (depth <= 0) {
                        filler = Blocks.field_150350_a.func_176223_P();
                    } else if (y > chunkGenerator.getWorld().func_181545_F() - 4 && y < chunkGenerator.getWorld().func_181545_F() + 3) {
                        filler = gravel || soulSand ? BlocksNether.heat_sand.func_176223_P() : this.field_76752_A;
                    }
                    depthRemaining = depth;
                    primer.func_177855_a(x, y, z, y >= chunkGenerator.getWorld().func_181545_F() ? filler : this.field_76752_A);
                    continue;
                }
                if (depthRemaining <= 0) continue;
                --depthRemaining;
                primer.func_177855_a(x, y, z, this.field_76752_A);
                continue;
            }
            depthRemaining = -1;
        }
    }

    public void func_180624_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos) {
        int i;
        super.func_180624_a(worldIn, rand, pos);
        int worldHeight = worldIn.func_72940_L();
        int treeTries = MathHelper.func_76136_a((Random)rand, (int)minTreeTries, (int)maxTreeTries);
        for (i = 0; i < treeTries; ++i) {
            this.func_150567_a(rand).func_180709_b(worldIn, rand, pos.func_177982_a(rand.nextInt(16) + 8, rand.nextInt(worldHeight - 4) + 4, rand.nextInt(16) + 8));
        }
        if (reedChance > 0) {
            for (i = 0; i < reedTries; ++i) {
                if (rand.nextInt(reedChance) != 0) continue;
                new NetherGenReeds().func_180709_b(worldIn, rand, pos.func_177982_a(rand.nextInt(16) + 8, 32, rand.nextInt(16) + 8));
            }
        }
        if (Math.max(purpleMushroomChance, greenMushroomChance) > 0) {
            int tries = mushroomTries;
            for (int i2 = 0; i2 < tries; ++i2) {
                BlockPos mushroomPos = null;
                if (purpleMushroomChance > 0 && rand.nextInt(purpleMushroomChance) == 0) {
                    mushroomPos = pos.func_177982_a(rand.nextInt(16) + 8, rand.nextInt(worldHeight - 4) + 4, rand.nextInt(16) + 8);
                    new WorldGenBush((BlockBush)BlocksNether.purple_glowshroom).func_180709_b(worldIn, rand, mushroomPos);
                }
                if (greenMushroomChance <= 0 || rand.nextInt(greenMushroomChance) != 0) continue;
                new WorldGenBush((BlockBush)BlocksNether.green_glowshroom).func_180709_b(worldIn, rand, mushroomPos != null ? mushroomPos : pos.func_177982_a(rand.nextInt(16) + 8, rand.nextInt(worldHeight - 4) + 4, rand.nextInt(16) + 8));
            }
        }
    }

    @Override
    public boolean canNetherCarveThrough(@Nonnull IBlockState state, @Nonnull ChunkPrimer primer, int x, int y, int z) {
        return state == this.field_76753_B || state == this.field_76752_A || state.func_177230_c() == BlocksNether.heat_sand;
    }

    @Nonnull
    public WorldGenAbstractTree func_150567_a(@Nonnull Random rand) {
        return new NetherGenTree();
    }
}

