/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.nethercraft;

import com.legacy.nethercraft.blocks.BlocksNether;
import com.legacy.nethercraft.entities.block.EntityGhastBomb;
import com.legacy.nethercraft.entities.hostile.EntityBloodyZombie;
import com.legacy.nethercraft.entities.hostile.EntityCamouflageSpider;
import com.legacy.nethercraft.entities.hostile.EntityDarkZombie;
import com.legacy.nethercraft.entities.hostile.EntityImp;
import com.legacy.nethercraft.entities.hostile.EntityLavaSlime;
import com.legacy.nethercraft.entities.item.EntityLavaBoat;
import com.legacy.nethercraft.entities.item.EntityNPainting;
import com.legacy.nethercraft.entities.projectile.EntityLiniumArrow;
import com.legacy.nethercraft.entities.projectile.EntityNeridiumArrow;
import com.legacy.nethercraft.entities.projectile.EntityNetherArrow;
import com.legacy.nethercraft.entities.projectile.EntityPyridiumArrow;
import com.legacy.nethercraft.entities.projectile.EntitySlimeEggs;
import com.legacy.nethercraft.entities.tribal.EntityTribalTrainee;
import com.legacy.nethercraft.entities.tribal.EntityTribalWarrior;
import com.legacy.nethercraft.world.NetherGenMinable;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.compat.nethercraft.BiomeNethercraft;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Biomes;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class NethercraftHandler {
    @Nonnull
    static final Field TRACKING_RANGE_FIELD = ObfuscationReflectionHelper.findField(EntityRegistry.EntityRegistration.class, (String)"trackingRange");
    @Nonnull
    static final Field UPDATE_FREQUENCY_FIELD = ObfuscationReflectionHelper.findField(EntityRegistry.EntityRegistration.class, (String)"updateFrequency");
    @Nonnull
    static final Field SENDS_VELOCITY_UPDATES_FIELD = ObfuscationReflectionHelper.findField(EntityRegistry.EntityRegistration.class, (String)"sendsVelocityUpdates");
    public static BiomeNethercraft GLOWING_GROVE;
    public static int foulitePerChunk;
    public static int fouliteOreSize;
    public static int fouliteMinHeight;
    public static int fouliteMaxHeight;
    public static int neridiumPerChunk;
    public static int neridiumOreSize;
    public static int neridiumMinHeight;
    public static int neridiumMaxHeight;
    public static int liniumPerChunk;
    public static int liniumOreSize;
    public static int liniumMinHeight;
    public static int liniumMaxHeight;
    public static int pyridiumPerChunk;
    public static int pyridiumOreSize;
    public static int pyridiumMinHeight;
    public static int pyridiumMaxHeight;
    public static int wPerChunk;
    public static int wOreSize;
    public static int wMinHeight;
    public static int wMaxHeight;

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        registry.registerBiome((Biome)GLOWING_GROVE, NetherAPIConfig.Nethercraft.glowingGroveWeight);
    }

    public static void init() {
        EntityRegistry.addSpawn(EntityCamouflageSpider.class, (int)60, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76778_j});
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityDarkZombie.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityLavaSlime.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityCamouflageSpider.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityImp.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityTribalTrainee.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityTribalWarrior.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityBloodyZombie.class, false)).ifPresent(NethercraftHandler::setSendsVelocityUpdates);
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityGhastBomb.class, false)).ifPresent(entry -> NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 10));
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityLiniumArrow.class, false)).ifPresent(entry -> NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 20));
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityNeridiumArrow.class, false)).ifPresent(entry -> NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 20));
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityNetherArrow.class, false)).ifPresent(entry -> NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 20));
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityPyridiumArrow.class, false)).ifPresent(entry -> NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 20));
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntitySlimeEggs.class, false)).ifPresent(entry -> {
            NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, 10);
            NethercraftHandler.setSendsVelocityUpdates(entry);
        });
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityLavaBoat.class, false)).ifPresent(entry -> {
            NethercraftHandler.setInt(TRACKING_RANGE_FIELD, entry, 80);
            NethercraftHandler.setSendsVelocityUpdates(entry);
        });
        Optional.ofNullable(EntityRegistry.instance().lookupModSpawn(EntityNPainting.class, false)).ifPresent(entry -> {
            NethercraftHandler.setInt(TRACKING_RANGE_FIELD, entry, 160);
            NethercraftHandler.setInt(UPDATE_FREQUENCY_FIELD, entry, Integer.MAX_VALUE);
        });
    }

    static void setInt(@Nonnull Field field, @Nonnull Object obj, int value) {
        try {
            field.setInt(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void setSendsVelocityUpdates(@Nonnull Object obj) {
        try {
            SENDS_VELOCITY_UPDATES_FIELD.setBoolean(obj, true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    static void registerBiomes(@Nonnull RegistryEvent.Register<Biome> event) {
        GLOWING_GROVE = new BiomeNethercraft();
        event.getRegistry().register((IForgeRegistryEntry)GLOWING_GROVE);
    }

    @SubscribeEvent
    static void generateOres(@Nonnull DecorateBiomeEvent.Pre event) {
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER) {
            NethercraftHandler.GLOWING_GROVE.field_76760_I.field_180294_c = event.getPos();
            NethercraftHandler.GLOWING_GROVE.field_76760_I.func_76795_a(event.getWorld(), event.getRand(), foulitePerChunk, (WorldGenerator)new NetherGenMinable(BlocksNether.foulite_ore.func_176223_P(), fouliteOreSize), fouliteMinHeight, fouliteMaxHeight << (event.getWorld().func_72940_L() >> 8));
            NethercraftHandler.GLOWING_GROVE.field_76760_I.func_76795_a(event.getWorld(), event.getRand(), neridiumPerChunk, (WorldGenerator)new NetherGenMinable(BlocksNether.neridium_ore.func_176223_P(), neridiumOreSize), neridiumMinHeight, neridiumMaxHeight << (event.getWorld().func_72940_L() >> 8));
            NethercraftHandler.GLOWING_GROVE.field_76760_I.func_76795_a(event.getWorld(), event.getRand(), liniumPerChunk, (WorldGenerator)new NetherGenMinable(BlocksNether.linium_ore.func_176223_P(), liniumOreSize), liniumMinHeight, liniumMaxHeight << (event.getWorld().func_72940_L() >> 8));
            NethercraftHandler.GLOWING_GROVE.field_76760_I.func_76795_a(event.getWorld(), event.getRand(), pyridiumPerChunk, (WorldGenerator)new NetherGenMinable(BlocksNether.pyridium_ore.func_176223_P(), pyridiumOreSize), pyridiumMinHeight, pyridiumMaxHeight << (event.getWorld().func_72940_L() >> 8));
            NethercraftHandler.GLOWING_GROVE.field_76760_I.func_76795_a(event.getWorld(), event.getRand(), wPerChunk, (WorldGenerator)new NetherGenMinable(BlocksNether.w_ore.func_176223_P(), wOreSize), wMinHeight, wMaxHeight << (event.getWorld().func_72940_L() >> 8));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void summonDarkZombie(@Nonnull ZombieEvent.SummonAidEvent event) {
        if (event.getResult() == Event.Result.DEFAULT && event.getSummonChance() > 0.0 && event.getWorld().field_73011_w.func_186058_p() == DimensionType.NETHER && event.getWorld().func_175659_aa() == EnumDifficulty.HARD && event.getWorld().func_82736_K().func_82766_b("doMobSpawning")) {
            if (event.getSummoner().func_70681_au().nextDouble() > event.getSummonChance()) {
                event.setResult(Event.Result.DENY);
            }
            event.setCustomSummonedAid((EntityZombie)new EntityDarkZombie(event.getWorld()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    static {
        foulitePerChunk = 20;
        fouliteOreSize = 14;
        fouliteMinHeight = 10;
        fouliteMaxHeight = 118;
        neridiumPerChunk = 8;
        neridiumOreSize = 14;
        neridiumMinHeight = 10;
        neridiumMaxHeight = 118;
        liniumPerChunk = 5;
        liniumOreSize = 4;
        liniumMinHeight = 10;
        liniumMaxHeight = 118;
        pyridiumPerChunk = 4;
        pyridiumOreSize = 6;
        pyridiumMinHeight = 10;
        pyridiumMaxHeight = 118;
        wPerChunk = 2;
        wOreSize = 4;
        wMinHeight = 10;
        wMaxHeight = 118;
    }
}

