/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.netherex;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logictechcorp.libraryex.event.LibExEventFactory;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;

public final class NetherExHandler {
    public static boolean doesXZShowFog() {
        return !NetherExConfig.client.visual.disableNetherFog;
    }

    public static boolean doesGravelGenerate() {
        return NetherExConfig.dimension.nether.generateGravel;
    }

    public static boolean doesSoulSandGenerate() {
        return NetherExConfig.dimension.nether.generateSoulSand;
    }

    public static void onChunkGenerate(@Nonnull Chunk chunk) {
        LibExEventFactory.onChunkGenerate((Chunk)chunk);
    }

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry, @Nonnull World world) {
        NetherEx.BIOME_DATA_MANAGER.onWorldUnload(new WorldEvent.Unload(world));
        NetherEx.BIOME_DATA_MANAGER.onWorldLoad(new WorldEvent.Load(world));
        NetherEx.BIOME_DATA_MANAGER.getCurrentBiomeEntries().values().forEach(registry::registerBiome);
    }

    @Nonnull
    public static List<Biome.SpawnListEntry> getSpawnableList(@Nonnull Biome biome, @Nonnull EnumCreatureType creatureType) {
        ArrayList<Biome.SpawnListEntry> spawns = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(creatureType));
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(biome);
        if (biomeData != BiomeData.EMPTY) {
            spawns.addAll(biomeData.getEntitySpawns(creatureType));
        }
        return spawns;
    }
}

