/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.stygian_end;

import fluke.stygian.Stygian;
import fluke.stygian.block.ModBlocks;
import fluke.stygian.config.Configs;
import fluke.stygian.world.BiomeRegistrar;
import fluke.stygian.world.biomes.BiomeEndJungle;
import fluke.stygian.world.feature.WorldGenEnderCanopy;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import git.jbredwards.nether_api.mod.common.world.gen.ChunkGeneratorTheEnd;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class StygianEndHandler {
    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        try {
            StygianEndHandler.registerBiomesUnofficial(registry);
        }
        catch (IncompatibleClassChangeError | ReflectiveOperationException throwable) {
            // empty catch block
        }
        registry.registerBiome(BiomeRegistrar.END_JUNGLE, NetherAPIConfig.StygianEnd.endJungleWeight);
        registry.registerBiome(BiomeRegistrar.END_VOLCANO, NetherAPIConfig.StygianEnd.endVolcanoWeight);
    }

    public static void init() {
        ((BiomeEndJungle)BiomeRegistrar.END_JUNGLE).endCanopyTree = new WorldGenEnderCanopy(false){

            public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
                if (world.func_72863_F() instanceof ChunkProviderServer && ((ChunkProviderServer)world.func_72863_F()).field_186029_c instanceof ChunkGeneratorTheEnd && ((ChunkGeneratorTheEnd)((ChunkProviderServer)world.func_72863_F()).field_186029_c).func_185960_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, 1, 1) < 25.0f) {
                    return false;
                }
                return super.func_180709_b(world, rand, pos);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        ModBlocks.endLeaves.func_150122_b(true);
    }

    static void registerBiomesUnofficial(@Nonnull INetherAPIRegistry registry) throws ReflectiveOperationException, IncompatibleClassChangeError {
        if (Configs.worldgen.biomeIDs.length > Configs.worldgen.biomeWeights.length) {
            throw new IllegalStateException("Found missing end biome weights in Stygian End Unofficial config!");
        }
        for (int i = 0; i < Configs.worldgen.biomeIDs.length; ++i) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(Configs.worldgen.biomeIDs[i]));
            if (biome == null) {
                Stygian.LOGGER.warn("Biome not found with ID: " + Configs.worldgen.biomeIDs[i] + ", skipping...");
                continue;
            }
            registry.registerBiome(biome, Configs.worldgen.biomeWeights[i]);
        }
    }
}

