/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world;

import git.jbredwards.nether_api.api.event.NetherAPIFogColorEvent;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IFogWorldProvider {
    @SideOnly(value=Side.CLIENT)
    public Vec3d getDefaultFogColor(@Nonnull Biome var1, float var2, float var3, double var4, double var6, double var8);

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    default public Vec3d getFogColor(@Nonnull World world, float celestialAngle, float partialTicks, double defaultR, double defaultG, double defaultB, @Nonnull FogEventSupplier eventConstructor) {
        Vec3d entityPos = ActiveRenderInfo.func_178806_a((Entity)Minecraft.func_71410_x().field_71439_g, (double)partialTicks);
        int originX = MathHelper.func_76140_b((double)entityPos.field_72450_a);
        int originZ = MathHelper.func_76140_b((double)entityPos.field_72449_c);
        double originDiffX = entityPos.field_72450_a - (double)originX;
        double originDiffZ = entityPos.field_72449_c - (double)originZ;
        int[] weights = new int[]{0, 1, 4, 6, 4, 1, 0};
        Vec3d color = Vec3d.field_186680_a;
        double totalWeight = 0.0;
        for (int offsetX = 0; offsetX < 6; ++offsetX) {
            double weightX = originDiffX * (double)(weights[offsetX] - weights[offsetX + 1]) + (double)weights[offsetX];
            int posX = originX + offsetX - 3;
            for (int offsetZ = 0; offsetZ < 6; ++offsetZ) {
                double weightZ = originDiffZ * (double)(weights[offsetZ] - weights[offsetZ + 1]) + (double)weights[offsetZ];
                int posZ = originZ + offsetZ - 3;
                Biome biome = world.func_180494_b(new BlockPos(posX, 0, posZ));
                NetherAPIFogColorEvent event = eventConstructor.create(biome, world, celestialAngle, partialTicks);
                event.fogR = defaultR;
                event.fogG = defaultG;
                event.fogB = defaultB;
                double weight = weightX * weightZ;
                totalWeight += weight;
                color = color.func_178787_e((MinecraftForge.EVENT_BUS.post((Event)event) ? new Vec3d(event.fogR, event.fogG, event.fogB) : this.getDefaultFogColor(biome, celestialAngle, partialTicks, defaultR, defaultG, defaultB)).func_186678_a(weight));
            }
        }
        return color.func_186678_a(1.0 / totalWeight);
    }

    @FunctionalInterface
    public static interface FogEventSupplier {
        @Nonnull
        public NetherAPIFogColorEvent create(@Nonnull Biome var1, @Nonnull World var2, float var3, float var4);
    }
}

