/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lumien.perfectspawn.handler.AsmHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerSpawnLogic {
    @Nullable
    public static Integer INITIAL_SPAWN_DIMENSION = null;
    @Nonnull
    public static Function<GameProfile, Integer> INITIAL_SPAWN_PER_PLAYER = profile -> null;
    @Nonnull
    public static final Int2BooleanMap RESPAWN_DIMENSIONS = new Int2BooleanOpenHashMap();

    public static boolean canSpawnInDimension(@Nonnull WorldProvider provider, @Nullable EntityPlayer player) {
        Integer perPlayer;
        int dimension = provider.getDimension();
        if (dimension == 0) {
            return true;
        }
        if (player != null && (perPlayer = INITIAL_SPAWN_PER_PLAYER.apply(player.func_146103_bH())) != null && dimension == perPlayer) {
            return true;
        }
        if (new Integer(dimension).equals(INITIAL_SPAWN_DIMENSION)) {
            return true;
        }
        if (RESPAWN_DIMENSIONS.containsKey(dimension)) {
            return RESPAWN_DIMENSIONS.get(dimension);
        }
        WorldRespawnData configData = WorldRespawnData.load();
        if (configData.initial == dimension) {
            return true;
        }
        if (configData.respawn.containsKey(dimension)) {
            return configData.respawn.get(dimension);
        }
        return provider.func_76567_e();
    }

    public static int getInitialSpawnDimension(@Nullable GameProfile profile) {
        Integer perPlayer;
        if (profile != null && (perPlayer = INITIAL_SPAWN_PER_PLAYER.apply(profile)) != null) {
            return perPlayer;
        }
        if (INITIAL_SPAWN_DIMENSION != null) {
            return INITIAL_SPAWN_DIMENSION;
        }
        return WorldRespawnData.load().initial;
    }

    public static final class WorldRespawnData
    extends WorldSavedData {
        @Nonnull
        public final Int2BooleanMap respawn = new Int2BooleanOpenHashMap();
        public int initial;
        @Nonnull
        public static final String ID = "nether_api:respawn_data";

        public WorldRespawnData(@Nonnull String id) {
            super(id);
        }

        public void func_76184_a(@Nonnull NBTTagCompound compound) {
            this.initial = compound.func_74762_e("Initial");
            this.respawn.clear();
            NBTTagCompound respawnTag = compound.func_74775_l("Overrides");
            respawnTag.func_150296_c().forEach(dim -> this.respawn.put(Integer.parseInt(dim), respawnTag.func_74767_n(dim)));
        }

        @Nonnull
        public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
            NBTTagCompound respawnTag = new NBTTagCompound();
            this.respawn.forEach((dim, override) -> respawnTag.func_74757_a(dim.toString(), override.booleanValue()));
            compound.func_74768_a("Initial", this.initial);
            compound.func_74782_a("Overrides", (NBTBase)respawnTag);
            return compound;
        }

        @Nonnull
        public static WorldRespawnData load() {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null) {
                return new WorldRespawnData(ID);
            }
            WorldServer overworld = server.func_71218_a(0);
            WorldRespawnData data = (WorldRespawnData)overworld.func_72943_a(WorldRespawnData.class, ID);
            if (data == null) {
                data = new WorldRespawnData(ID);
                overworld.func_72823_a(ID, (WorldSavedData)data);
                data.initial = NetherAPI.isPerfectSpawnLoaded ? WorldRespawnData.perfectSpawnDim() : NetherAPIConfig.initialSpawnDim;
                data.respawn.putAll(Arrays.stream(NetherAPIConfig.respawnDims).map(config -> {
                    try {
                        JsonObject json = JsonUtils.func_151210_l((JsonElement)new JsonParser().parse(config), (String)config);
                        return Pair.of((Object)JsonUtils.func_151203_m((JsonObject)json, (String)"DimId"), (Object)JsonUtils.func_151212_i((JsonObject)json, (String)"Respawn"));
                    }
                    catch (JsonParseException e) {
                        System.err.println("An error occurred while parsing \"" + config + "\", skipping...");
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
                data.func_76186_a(true);
            }
            return data;
        }

        private static int perfectSpawnDim() {
            return AsmHandler.overrideInitialDimension((int)NetherAPIConfig.initialSpawnDim);
        }
    }
}

