/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.biome;

import com.google.common.collect.ImmutableList;
import git.jbredwards.nether_api.api.biome.INoSpawnBiome;
import git.jbredwards.nether_api.api.event.NetherAPIRegistryEvent;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BiomeProviderNetherAPI
extends BiomeProvider {
    protected BiomeProviderNetherAPI(@Nonnull World world, @Nonnull INetherAPIRegistry registry, @Nonnull BiFunction<INetherAPIRegistry, World, NetherAPIRegistryEvent> eventSupplier) {
        if (registry.isEmpty()) {
            MinecraftForge.EVENT_BUS.post((Event)eventSupplier.apply(registry, world));
        }
        if (registry.getBiomeEntries().isEmpty()) {
            String id = world.field_73011_w.func_186058_p().func_186065_b();
            throw new IllegalStateException("Dimension with id: \"" + id + "\" has no biomes, try adjusting your config settings!");
        }
        GenLayer[] biomeGenerators = this.getModdedBiomeGenerators(world.func_175624_G(), world.func_72905_C(), this.getBiomeGenerators(world.func_175624_G(), world.func_72905_C(), registry));
        this.field_76944_d = biomeGenerators[0];
        this.field_76945_e = biomeGenerators[1];
        this.field_76943_g = (List)registry.getBiomeEntries().stream().map(entry -> entry.biome).filter(biome -> !(biome instanceof INoSpawnBiome)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public abstract GenLayer[] getBiomeGenerators(@Nonnull WorldType var1, long var2, @Nonnull INetherAPIRegistry var4);

    @Nonnull
    public abstract GenLayer[] getModdedBiomeGenerators(@Nonnull WorldType var1, long var2, @Nonnull GenLayer[] var4);

    @Nonnull
    public Biome[] func_76937_a(@Nullable Biome[] listToReuse, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int size = width * height;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new Biome[size];
        }
        int[] biomeIds = this.field_76944_d.func_75904_a(x, z, width, height);
        for (int i = 0; i < size; ++i) {
            int biomeId = biomeIds[i];
            listToReuse[i] = Objects.requireNonNull(Biome.func_150568_d((int)biomeId), () -> "Unmapped biome id: " + biomeId);
        }
        return listToReuse;
    }

    @Nonnull
    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int height, boolean cacheFlag) {
        IntCache.func_76446_a();
        int size = width * height;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new Biome[size];
        }
        if (cacheFlag && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] biomes = this.field_76942_f.func_76839_e(x, z);
            System.arraycopy(biomes, 0, listToReuse, 0, size);
            return listToReuse;
        }
        int[] biomeIds = this.field_76945_e.func_75904_a(x, z, width, height);
        for (int i = 0; i < size; ++i) {
            int biomeId = biomeIds[i];
            listToReuse[i] = Objects.requireNonNull(Biome.func_150568_d((int)biomeId), () -> "Unmapped biome id: " + biomeId);
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, @Nonnull List<Biome> allowed) {
        return !allowed.isEmpty() && super.func_76940_a(x, z, radius << 2, allowed);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, @Nonnull List<Biome> biomes, @Nonnull Random random) {
        return biomes.isEmpty() ? null : super.func_180630_a(x, z, range << 2, biomes, random);
    }
}

