/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.gen;

import git.jbredwards.nether_api.api.biome.INetherBiome;
import git.jbredwards.nether_api.api.structure.ISpawningStructure;
import git.jbredwards.nether_api.api.util.NetherGenerationUtils;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.compat.netherex.NetherExHandler;
import git.jbredwards.nether_api.mod.common.compat.voidislandcontrol.VoidIslandControlHandler;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorNether
extends ChunkGeneratorHell
implements INetherAPIChunkGenerator {
    @Nonnull
    protected final NoiseGeneratorPerlin terrainNoiseGen;
    @Nonnull
    protected final MapGenStructure[] moddedStructures;
    @Nonnull
    protected Biome[] biomesForGeneration = new Biome[0];

    public ChunkGeneratorNether(@Nonnull World worldIn, boolean generateStructures, long seed) {
        super(worldIn, generateStructures, seed);
        this.terrainNoiseGen = new NoiseGeneratorPerlin(this.field_185954_p, 4);
        this.field_189888_D = new WorldGenMinable(Blocks.field_189877_df.func_176223_P(), 33, state -> state == field_185941_b || state.func_185917_h() && state.func_185904_a() != Material.field_151576_e);
        this.moddedStructures = (MapGenStructure[])NetherAPIRegistry.NETHER.getStructures().stream().map(entry -> entry.getStructureFactory().apply(this)).toArray(MapGenStructure[]::new);
    }

    public void func_185936_a(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        if (VoidIslandControlHandler.isVoid(this.field_185952_n)) {
            return;
        }
        int lavaHeight = (this.field_185952_n.func_181545_F() >> 1) + 1;
        int noiseHeight = (this.field_185952_n.func_72940_L() >> 3) + 1;
        int noiseWidthX = 5;
        int noiseWidthZ = 5;
        this.field_185956_t = this.func_185938_a(this.field_185956_t, chunkX << 2, 0, chunkZ << 2, 5, noiseHeight, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int heightIndex = noiseHeight - 2; heightIndex >= 0; --heightIndex) {
                    double d1 = this.field_185956_t[((j1 + 0) * 5 + k1 + 0) * noiseHeight + heightIndex];
                    double d2 = this.field_185956_t[((j1 + 0) * 5 + k1 + 1) * noiseHeight + heightIndex];
                    double d3 = this.field_185956_t[((j1 + 1) * 5 + k1 + 0) * noiseHeight + heightIndex];
                    double d4 = this.field_185956_t[((j1 + 1) * 5 + k1 + 1) * noiseHeight + heightIndex];
                    double d5 = (this.field_185956_t[((j1 + 0) * 5 + k1 + 0) * noiseHeight + heightIndex + 1] - d1) * 0.125;
                    double d6 = (this.field_185956_t[((j1 + 0) * 5 + k1 + 1) * noiseHeight + heightIndex + 1] - d2) * 0.125;
                    double d7 = (this.field_185956_t[((j1 + 1) * 5 + k1 + 0) * noiseHeight + heightIndex + 1] - d3) * 0.125;
                    double d8 = (this.field_185956_t[((j1 + 1) * 5 + k1 + 1) * noiseHeight + heightIndex + 1] - d4) * 0.125;
                    for (int yOffset = 0; yOffset < 8; ++yOffset) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int xOffset = 0; xOffset < 4; ++xOffset) {
                            double density = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                                int y = (heightIndex << 3) + yOffset;
                                IBlockState state = null;
                                if (y < lavaHeight) {
                                    state = field_185943_d;
                                }
                                if (density > 0.0) {
                                    state = field_185941_b;
                                }
                                primer.func_177855_a((j1 << 2) + xOffset, y, (k1 << 2) + zOffset, state);
                                density += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_185937_b(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        if (VoidIslandControlHandler.isVoid(this.field_185952_n) || !ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.field_185952_n)) {
            return;
        }
        int originX = chunkX << 4;
        int originZ = chunkZ << 4;
        this.field_73185_q = this.field_73177_m.func_76304_a(this.field_73185_q, originX, originZ, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.field_73184_r = this.field_73177_m.func_76304_a(this.field_73184_r, originX, 109, originZ, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.field_185955_s = this.field_73174_n.func_76304_a(this.field_185955_s, originX, originZ, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        double[] terrainNoise = this.terrainNoiseGen.func_151599_a(null, (double)originX, (double)originZ, 16, 16, 0.0625, 0.0625, 1.0);
        for (int posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                for (int posY = 4; posY >= 0; --posY) {
                    if (posY <= this.field_185954_p.nextInt(5)) {
                        primer.func_177855_a(posX, posY, posZ, field_185942_c);
                    }
                    if (posY < 4 - this.field_185954_p.nextInt(5)) continue;
                    primer.func_177855_a(posX, posY + this.field_185952_n.func_72940_L() - 5, posZ, field_185942_c);
                }
                Biome biome = this.biomesForGeneration[posZ << 4 | posX];
                if (biome instanceof INetherBiome) {
                    ((INetherBiome)biome).buildSurface(this, chunkX, chunkZ, primer, posX, posZ, this.field_73185_q, this.field_73184_r, this.field_185955_s, terrainNoise[posZ << 4 | posX]);
                    continue;
                }
                NetherGenerationUtils.buildSurfaceAndSoulSandGravel(this.field_185952_n, this.field_185954_p, primer, posX, posZ, this.field_73185_q, this.field_73184_r, this.field_185955_s, field_185941_b, biome.field_76752_A, biome.field_76753_B, field_185943_d);
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        this.field_185954_p.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.biomesForGeneration = this.field_185952_n.func_72959_q().func_76933_b(null, x << 4, z << 4, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInPrimer(x, z, primer);
        this.func_185937_b(x, z, primer);
        if (NetherAPIConfig.hellCaves) {
            this.field_185939_I.func_186125_a(this.field_185952_n, x, z, primer);
        }
        if (this.areStructuresEnabled()) {
            if (this.field_73172_c != null) {
                this.field_73172_c.func_186125_a(this.field_185952_n, x, z, primer);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                structure.func_186125_a(this.field_185952_n, x, z, primer);
            }
        }
        Chunk chunk = new Chunk(this.field_185952_n, primer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76613_n();
        if (NetherAPI.isNetherExLoaded) {
            NetherExHandler.onChunkGenerate(chunk);
        }
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean prevFixVanillaCascading = ForgeModContainer.fixVanillaCascading;
        ForgeModContainer.fixVanillaCascading = true;
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.field_185952_n.func_180494_b(pos.func_177982_a(16, 0, 16));
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        for (MapGenStructure structure : this.moddedStructures) {
            structure.func_175794_a(this.field_185952_n, this.field_185954_p, chunkPos);
        }
        if (!(biome instanceof INetherBiome)) {
            this.populateWithVanilla(chunkX, chunkZ);
        } else {
            BlockFalling.field_149832_M = true;
            if (this.field_73172_c != null) {
                this.field_73172_c.func_175794_a(this.field_185952_n, this.field_185954_p, chunkPos);
            }
            ((INetherBiome)biome).populate(this, chunkX, chunkZ);
            BlockFalling.field_149832_M = false;
        }
        ForgeModContainer.fixVanillaCascading = prevFixVanillaCascading;
    }

    @Override
    public void populateWithVanilla(int chunkX, int chunkZ) {
        int i;
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        int originX = chunkX << 4;
        int originZ = chunkZ << 4;
        int maxHeight = this.field_185952_n.func_72940_L();
        boolean heightGenFactor = false;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockPos pos = new BlockPos(originX, 0, originZ);
        Biome biome = this.field_185952_n.func_180494_b(pos.func_177982_a(16, 0, 16));
        if (this.field_73172_c != null && !(biome instanceof INetherBiome)) {
            this.field_73172_c.func_175794_a(this.field_185952_n, this.field_185954_p, chunkPos);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA)) {
            for (i = 0; i < 8; ++i) {
                this.field_177472_y.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight - 8) + 4, this.field_185954_p.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE)) {
            for (i = 0; i < this.field_185954_p.nextInt(this.field_185954_p.nextInt(10) + 1) + 1 << 0; ++i) {
                this.field_177470_t.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight - 8) + 4, this.field_185954_p.nextInt(16) + 8));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
            for (i = 0; i < this.field_185954_p.nextInt(this.field_185954_p.nextInt(10) + 1) + 1 << 0; ++i) {
                this.field_177469_u.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight - 8) + 4, this.field_185954_p.nextInt(16) + 8));
            }
            for (i = 0; i < 10; ++i) {
                this.field_177468_v.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight), this.field_185954_p.nextInt(16) + 8));
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.field_185952_n, this.field_185954_p, chunkPos));
        if (TerrainGen.decorate((World)this.field_185952_n, (Random)this.field_185954_p, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            for (i = 0; i < 1; ++i) {
                if (this.field_185954_p.nextBoolean()) {
                    this.field_177471_z.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight), this.field_185954_p.nextInt(16) + 8));
                }
                if (!this.field_185954_p.nextBoolean()) continue;
                this.field_177465_A.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight), this.field_185954_p.nextInt(16) + 8));
            }
        }
        if (TerrainGen.generateOre((World)this.field_185952_n, (Random)this.field_185954_p, (WorldGenerator)this.field_177467_w, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.QUARTZ)) {
            for (i = 0; i < 16; ++i) {
                this.field_177467_w.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16), this.field_185954_p.nextInt(maxHeight - 20) + 10, this.field_185954_p.nextInt(16)));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_MAGMA)) {
            for (i = 0; i < 4; ++i) {
                this.field_189888_D.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16), (this.field_185952_n.func_181545_F() >> 1) - 4 + this.field_185954_p.nextInt(10), this.field_185954_p.nextInt(16)));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.field_185952_n, (Random)this.field_185954_p, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.NETHER_LAVA2)) {
            for (i = 0; i < 16; ++i) {
                this.field_177473_x.func_180709_b(this.field_185952_n, this.field_185954_p, pos.func_177982_a(this.field_185954_p.nextInt(16) + 8, this.field_185954_p.nextInt(maxHeight - 20) + 10, this.field_185954_p.nextInt(16) + 8));
            }
        }
        biome.func_180624_a(this.field_185952_n, this.field_185954_p, new BlockPos(originX, 0, originZ));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.field_185952_n, this.field_185954_p, chunkPos));
        BlockFalling.field_149832_M = false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            if (creatureType == EnumCreatureType.MONSTER && this.field_73172_c != null && (this.field_73172_c.func_175795_b(pos) || this.field_73172_c.func_175796_a(this.field_185952_n, pos) && this.field_185952_n.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj)) {
                return this.field_73172_c.func_75059_a();
            }
            for (MapGenStructure structure : this.moddedStructures) {
                List<Biome.SpawnListEntry> possibleCreatures;
                if (!(structure instanceof ISpawningStructure) || (possibleCreatures = ((ISpawningStructure)structure).getPossibleCreatures(creatureType, this.field_185952_n, pos)).isEmpty()) continue;
                return possibleCreatures;
            }
        }
        return NetherAPI.isNetherExLoaded ? NetherExHandler.getSpawnableList(this.field_185952_n.func_180494_b(pos), creatureType) : this.field_185952_n.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        if (this.areStructuresEnabled()) {
            if ("Fortress".equals(structureName) && this.field_73172_c != null) {
                return this.field_73172_c.func_180706_b(worldIn, position, findUnexplored);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_180706_b(worldIn, position, findUnexplored);
            }
        }
        return null;
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            if ("Fortress".equals(structureName) && this.field_73172_c != null) {
                return this.field_73172_c.func_175795_b(pos);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_175795_b(pos);
            }
        }
        return false;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
        if (this.areStructuresEnabled()) {
            this.field_73172_c.func_186125_a(this.field_185952_n, x, z, null);
            for (MapGenStructure structure : this.moddedStructures) {
                structure.func_186125_a(this.field_185952_n, x, z, null);
            }
        }
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.field_185952_n;
    }

    @Override
    @Nonnull
    public Random getRand() {
        return this.field_185954_p;
    }

    @Override
    public boolean areStructuresEnabled() {
        return this.field_185953_o;
    }

    @Override
    public void setBlocksInPrimer(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        this.func_185936_a(chunkX, chunkZ, primer);
    }
}

