/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.gen;

import git.jbredwards.nether_api.api.biome.IEndBiome;
import git.jbredwards.nether_api.api.structure.ISpawningStructure;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import git.jbredwards.nether_api.mod.common.compat.voidislandcontrol.VoidIslandControlHandler;
import git.jbredwards.nether_api.mod.common.config.NetherAPIConfig;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.world.WorldProviderTheEnd;
import git.jbredwards.nether_api.mod.common.world.biome.BiomeProviderTheEnd;
import git.jbredwards.nether_api.mod.common.world.gen.MapGenCavesEnd;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkGeneratorTheEnd
extends ChunkGeneratorEnd
implements INetherAPIChunkGenerator {
    @Nonnull
    protected final NoiseGeneratorPerlin terrainNoiseGen;
    @Nonnull
    protected final MapGenCavesEnd genEndCaves = new MapGenCavesEnd();
    @Nonnull
    protected final MapGenStructure[] moddedStructures;
    @Nonnull
    protected Biome[] field_73231_z = new Biome[0];

    public ChunkGeneratorTheEnd(@Nonnull World worldIn, boolean generateStructures, @Nonnull BiomeProviderTheEnd biomeProvider, @Nonnull BlockPos spawnCoord) {
        super(worldIn, generateStructures, worldIn.func_72905_C(), spawnCoord);
        this.terrainNoiseGen = new NoiseGeneratorPerlin(this.field_73220_k, 4);
        this.field_185973_o = biomeProvider.islandNoise;
        this.moddedStructures = (MapGenStructure[])NetherAPIRegistry.THE_END.getStructures().stream().map(entry -> entry.getStructureFactory().apply(this)).toArray(MapGenStructure[]::new);
    }

    public void func_180518_a(int x, int z, @Nonnull ChunkPrimer primer) {
        if (VoidIslandControlHandler.isVoid(this.field_73230_p)) {
            return;
        }
        super.func_180518_a(x, z, primer);
    }

    public void buildSurfaces(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        if (VoidIslandControlHandler.isVoid(this.field_73230_p) || !ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.field_73230_p)) {
            return;
        }
        double[] terrainNoise = this.terrainNoiseGen.func_151599_a(null, (double)(chunkX << 4), (double)(chunkZ << 4), 16, 16, 0.0625, 0.0625, 1.0);
        for (int posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                Biome biome = this.field_73231_z[posZ << 4 | posX];
                if (!(biome instanceof IEndBiome)) continue;
                ((IEndBiome)biome).buildSurface(this, chunkX, chunkZ, primer, posX, posZ, terrainNoise[posZ << 4 | posX]);
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.field_73220_k.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(null, chunkX << 4, chunkZ << 4, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInPrimer(chunkX, chunkZ, primer);
        this.buildSurfaces(chunkX, chunkZ, primer);
        if (NetherAPIConfig.endCaves) {
            this.genEndCaves.func_186125_a(this.field_73230_p, chunkX, chunkZ, primer);
        }
        if (this.areStructuresEnabled()) {
            if (this.field_185972_n != null) {
                this.field_185972_n.func_186125_a(this.field_73230_p, chunkX, chunkZ, primer);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                structure.func_186125_a(this.field_73230_p, chunkX, chunkZ, primer);
            }
        }
        Chunk chunk = new Chunk(this.field_73230_p, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.field_73231_z[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean prevFixVanillaCascading = ForgeModContainer.fixVanillaCascading;
        ForgeModContainer.fixVanillaCascading = true;
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.field_73230_p.func_180494_b(pos.func_177982_a(16, 0, 16));
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        for (MapGenStructure structure : this.moddedStructures) {
            structure.func_175794_a(this.field_73230_p, this.field_73220_k, chunkPos);
        }
        if (!(biome instanceof IEndBiome)) {
            this.populateWithVanilla(chunkX, chunkZ);
        } else {
            BlockFalling.field_149832_M = true;
            if (this.field_185972_n != null) {
                this.field_185972_n.func_175794_a(this.field_73230_p, this.field_73220_k, chunkPos);
            }
            ((IEndBiome)biome).populate(this, chunkX, chunkZ);
            BlockFalling.field_149832_M = false;
        }
        ForgeModContainer.fixVanillaCascading = prevFixVanillaCascading;
    }

    @Override
    public void populateWithVanilla(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.field_73230_p, (Random)this.field_73220_k, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.field_73230_p.func_180494_b(pos.func_177982_a(16, 0, 16));
        if (this.areStructuresEnabled() && !(biome instanceof IEndBiome)) {
            this.field_185972_n.func_175794_a(this.field_73230_p, this.field_73220_k, new ChunkPos(chunkX, chunkZ));
        }
        if ((long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ > 4096L) {
            int zOffset;
            int xOffset;
            int blockHeight;
            float height = this.func_185960_a(chunkX, chunkZ, 1, 1);
            if ((!(biome instanceof IEndBiome) || ((IEndBiome)biome).generateIslands(this, chunkX, chunkZ, height)) && height < -20.0f && this.field_73220_k.nextInt(14) == 0) {
                this.field_185975_r.func_180709_b(this.field_73230_p, this.field_73220_k, pos.func_177982_a(this.field_73220_k.nextInt(16) + 8, 55 + this.field_73220_k.nextInt(16), this.field_73220_k.nextInt(16) + 8));
                if (this.field_73220_k.nextInt(4) == 0) {
                    this.field_185975_r.func_180709_b(this.field_73230_p, this.field_73220_k, pos.func_177982_a(this.field_73220_k.nextInt(16) + 8, 55 + this.field_73220_k.nextInt(16), this.field_73220_k.nextInt(16) + 8));
                }
            }
            if ((!(biome instanceof IEndBiome) || ((IEndBiome)biome).generateChorusPlants(this, chunkX, chunkZ, height)) && height > 40.0f) {
                int amountInChunk = this.field_73220_k.nextInt(5);
                for (int i = 0; i < amountInChunk; ++i) {
                    BlockPos soil;
                    IBlockState ground;
                    int zOffset2;
                    int xOffset2 = this.field_73220_k.nextInt(16) + 8;
                    int y = this.field_73230_p.func_175645_m(pos.func_177982_a(xOffset2, 0, zOffset2 = this.field_73220_k.nextInt(16) + 8)).func_177956_o();
                    if (y <= 0 || !this.field_73230_p.func_175623_d(pos.func_177982_a(xOffset2, y, zOffset2)) || !(ground = this.field_73230_p.func_180495_p(soil = pos.func_177982_a(xOffset2, y - 1, zOffset2))).func_177230_c().canSustainPlant(ground, (IBlockAccess)this.field_73230_p, soil, EnumFacing.UP, (IPlantable)Blocks.field_185766_cS)) continue;
                    BlockChorusFlower.func_185603_a((World)this.field_73230_p, (BlockPos)soil.func_177984_a(), (Random)this.field_73220_k, (int)8);
                }
            }
            if (height > 40.0f && this.field_73220_k.nextInt(700) == 0 && (blockHeight = this.field_73230_p.func_175645_m(pos.func_177982_a(xOffset = this.field_73220_k.nextInt(16) + 8, 0, zOffset = this.field_73220_k.nextInt(16) + 8)).func_177956_o()) > 0) {
                BlockPos offset = pos.func_177982_a(xOffset, blockHeight + 3 + this.field_73220_k.nextInt(7), zOffset);
                WorldProviderTheEnd.END_GATEWAY.func_180709_b(this.field_73230_p, this.field_73220_k, offset);
                TileEntity tile = this.field_73230_p.func_175625_s(offset);
                if (tile instanceof TileEntityEndGateway) {
                    ((TileEntityEndGateway)tile).func_190603_b(this.field_191061_n);
                }
            }
        }
        biome.func_180624_a(this.field_73230_p, this.field_73220_k, pos);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.field_73230_p, (Random)this.field_73220_k, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            for (MapGenStructure structure : this.moddedStructures) {
                List<Biome.SpawnListEntry> possibleCreatures;
                if (!(structure instanceof ISpawningStructure) || (possibleCreatures = ((ISpawningStructure)structure).getPossibleCreatures(creatureType, this.field_73230_p, pos)).isEmpty()) continue;
                return possibleCreatures;
            }
        }
        return this.field_73230_p.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        if (this.areStructuresEnabled()) {
            if ("EndCity".equals(structureName) && this.field_185972_n != null) {
                return this.field_185972_n.func_180706_b(worldIn, position, findUnexplored);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_180706_b(worldIn, position, findUnexplored);
            }
        }
        return null;
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            if ("EndCity".equals(structureName) && this.field_185972_n != null) {
                return this.field_185972_n.func_175795_b(pos);
            }
            for (MapGenStructure structure : this.moddedStructures) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_175795_b(pos);
            }
        }
        return false;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
        if (this.areStructuresEnabled()) {
            for (MapGenStructure structure : this.moddedStructures) {
                structure.func_186125_a(this.field_73230_p, x, z, null);
            }
        }
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.field_73230_p;
    }

    @Override
    @Nonnull
    public Random getRand() {
        return this.field_73220_k;
    }

    @Override
    public boolean areStructuresEnabled() {
        return this.field_73229_q;
    }

    @Override
    public void setBlocksInPrimer(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        this.func_180518_a(chunkX, chunkZ, primer);
    }
}

