/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.gen.layer;

import git.jbredwards.nether_api.api.biome.INetherAPIBiomeProvider;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerNetherEdgeBiomes
extends GenLayer {
    public GenLayerNetherEdgeBiomes(long seed, @Nonnull GenLayer parentIn) {
        super(seed);
        this.field_75909_a = parentIn;
    }

    @Nonnull
    public int[] func_75904_a(int areaX, int areaZ, int areaWidth, int areaHeight) {
        int[] out = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        int[] biomeIds = this.field_75909_a.func_75904_a(areaX - 1, areaZ - 1, areaWidth + 2, areaHeight + 2);
        for (int x = 0; x < areaWidth; ++x) {
            for (int z = 0; z < areaHeight; ++z) {
                this.func_75903_a(areaX + x, areaZ + z);
                int biomeId = biomeIds[x + 1 + (z + 1) * (areaHeight + 2)];
                int index = x + z * areaHeight;
                out[index] = biomeId;
                int finalX = x;
                int finalZ = z;
                for (BooleanSupplier supplier : this.shuffle(() -> this.handleNeighborBiome(out, index, biomeIds[finalX + 1 + (finalZ + 1 - 1) * (areaHeight + 2)]), () -> this.handleNeighborBiome(out, index, biomeIds[finalX + 1 + 1 + (finalZ + 1) * (areaHeight + 2)]), () -> this.handleNeighborBiome(out, index, biomeIds[finalX + 1 - 1 + (finalZ + 1) * (areaHeight + 2)]), () -> this.handleNeighborBiome(out, index, biomeIds[finalX + 1 + (finalZ + 1 + 1) * (areaHeight + 2)]))) {
                    if (supplier.getAsBoolean()) break;
                }
            }
        }
        return out;
    }

    @Nonnull
    @SafeVarargs
    protected final <T> T[] shuffle(T ... original) {
        for (int i = original.length - 1; i > 0; --i) {
            T temp = original[i];
            int rand = this.func_75902_a(i + 1);
            original[i] = original[rand];
            original[rand] = temp;
        }
        return original;
    }

    protected boolean handleNeighborBiome(@Nonnull int[] out, int index, int neighborId) {
        List<BiomeManager.BiomeEntry> edgeBiomes;
        Biome biome;
        if (out[index] != neighborId && (biome = Biome.func_185357_a((int)out[index])) instanceof INetherAPIBiomeProvider && !(edgeBiomes = ((INetherAPIBiomeProvider)biome).getEdgeBiomes(neighborId)).isEmpty()) {
            int totalWeight = WeightedRandom.func_76272_a(edgeBiomes);
            Biome edgeBiome = ((BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(edgeBiomes, (int)this.func_75902_a((int)totalWeight))).biome;
            out[index] = Biome.func_185362_a((Biome)edgeBiome);
            return true;
        }
        return false;
    }
}

