/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.recipe;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9887;

public class BrewingRecipe
implements class_1860<BrewingRecipeInput> {
    private final class_1856 reagent;
    private final CauldronContents potion;
    private final CauldronContents result;
    private final class_2394 particleType;
    private final boolean requiresHeat;

    public BrewingRecipe(class_1856 reagent, CauldronContents potion, CauldronContents result, class_2394 particleType, boolean requiresHeat) {
        this.reagent = reagent;
        this.potion = potion;
        this.result = result;
        this.particleType = particleType;
        this.requiresHeat = requiresHeat;
    }

    public boolean matches(BrewingRecipeInput input, class_1937 level) {
        if (!this.requiresHeat || input.isHeated()) {
            return this.reagent.method_8093(input.method_59984(0)) && this.potion.test(input.getContents());
        }
        return false;
    }

    public class_1799 assemble(BrewingRecipeInput input, class_7225.class_7874 registries) {
        return this.getResultItem();
    }

    public class_1856 getReagent() {
        return this.reagent;
    }

    public CauldronContents getPotion() {
        return this.potion;
    }

    public class_2960 getContentsId() {
        return this.potion.id();
    }

    public class_1799 getResultItem() {
        if (this.result.potion().isPresent()) {
            return CauldronContents.createItemStack(class_1802.field_8574, this.result);
        }
        return ((class_2248)class_7923.field_41175.method_63535(this.result.id())).method_8389().method_7854();
    }

    public CauldronContents getResultPotion() {
        return this.result;
    }

    public class_1865<BrewingRecipe> method_8119() {
        return CauldronModRecipes.BREWING_SERIALIZER.get();
    }

    public class_3956<BrewingRecipe> method_17716() {
        return CauldronModRecipes.BREWING.get();
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public class_10355 method_64668() {
        return null;
    }

    public boolean method_8118() {
        return true;
    }

    public class_2394 getParticleType() {
        return this.particleType;
    }

    public static class Serializer
    implements class_1865<BrewingRecipe> {
        public static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_1856.field_46095.fieldOf("reagent").forGetter(r -> r.reagent), (App)CauldronContents.CODEC.fieldOf("potion").forGetter(r -> r.potion), (App)CauldronContents.CODEC.fieldOf("result").forGetter(r -> r.result), (App)class_2398.field_25125.optionalFieldOf("particle_type", (Object)class_2398.field_11247).forGetter(r -> r.particleType), (App)Codec.BOOL.optionalFieldOf("requires_heat", (Object)((Boolean)CauldronMod.CONFIG.requiresHeat.value())).forGetter(r -> r.requiresHeat)).apply((Applicative)inst, BrewingRecipe::new));
        public static final class_9139<class_9129, BrewingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        private static BrewingRecipe fromNetwork(class_9129 buf) {
            class_1856 reagent = (class_1856)class_1856.field_48355.decode((Object)buf);
            CauldronContents potion = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            CauldronContents result = (CauldronContents)CauldronContents.STREAM_CODEC.decode((Object)buf);
            class_2394 particleType = (class_2394)class_2398.field_48456.decode((Object)buf);
            boolean requiresHeat = buf.readBoolean();
            return new BrewingRecipe(reagent, potion, result, particleType, requiresHeat);
        }

        private static void toNetwork(class_9129 buf, BrewingRecipe recipe) {
            class_1856.field_48355.encode((Object)buf, (Object)recipe.reagent);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.potion);
            CauldronContents.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            class_2398.field_48456.encode((Object)buf, (Object)recipe.particleType);
            buf.method_52964(recipe.requiresHeat);
        }

        public MapCodec<BrewingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BrewingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

