/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.blocks.entity;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.blocks.BrewingCauldronBlock;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.core.CauldronModTags;
import cc.cassian.cauldrons.recipe.BrewingRecipe;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import cc.cassian.cauldrons.recipe.DippingRecipe;
import cc.cassian.cauldrons.registry.CauldronModBlockEntityTypes;
import cc.cassian.cauldrons.registry.CauldronModBlocks;
import cc.cassian.cauldrons.registry.CauldronModSoundEvents;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1278;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5556;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class CauldronBlockEntity
extends class_2586
implements class_1278 {
    protected CauldronContents contents = CauldronContents.EMPTY;
    protected boolean splashing = false;
    protected boolean lingering = false;
    private int progress;
    private int maxProgress;
    private int bubbleTimer;
    private boolean pop;
    private class_1799 reagent;
    private class_2394 particleType;

    public CauldronBlockEntity(class_2338 pos, class_2680 state, CauldronContents contents) {
        super(CauldronModBlockEntityTypes.CAULDRON_BLOCK_ENTITY.get(), pos, state);
        this.maxProgress = (Integer)CauldronMod.CONFIG.brewingTime.value() * 20;
        this.bubbleTimer = 0;
        this.pop = false;
        this.reagent = class_1799.field_8037;
        this.particleType = class_2398.field_11247;
        this.contents = contents;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public CauldronBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(CauldronModBlockEntityTypes.CAULDRON_BLOCK_ENTITY.get(), blockPos, blockState);
        this.maxProgress = (Integer)CauldronMod.CONFIG.brewingTime.value() * 20;
        this.bubbleTimer = 0;
        this.pop = false;
        this.reagent = class_1799.field_8037;
        this.particleType = class_2398.field_11247;
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        class_2520 inventory = tag.method_10580("cauldron.inventory");
        this.reagent = inventory != null ? class_1799.method_57360((class_7225.class_7874)registries, (class_2520)inventory).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.progress = tag.method_10550("cauldron.progress");
        this.maxProgress = tag.method_10550("cauldron.max_progress");
        this.contents = (CauldronContents)((com.mojang.datafixers.util.Pair)CauldronContents.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("cauldron.potion")).result().get()).getFirst();
        this.splashing = tag.method_10577("cauldron.splashing");
        this.lingering = tag.method_10577("cauldron.lingering");
        this.bubbleTimer = tag.method_10550("cauldron.bubble_timer");
        if (tag.method_10545("cauldron.particle_type")) {
            this.particleType = (class_2394)((com.mojang.datafixers.util.Pair)class_2398.field_25125.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("cauldron.particle_type")).result().get()).getFirst();
        }
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        if (!this.reagent.method_7960()) {
            tag.method_10566("cauldron.inventory", this.reagent.method_57358(registries));
        }
        tag.method_10569("cauldron.progress", this.progress);
        tag.method_10569("cauldron.max_progress", this.maxProgress);
        tag.method_10566("cauldron.potion", (class_2520)CauldronContents.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.contents).result().get());
        tag.method_10556("cauldron.splashing", this.splashing);
        tag.method_10556("cauldron.lingering", this.lingering);
        tag.method_10569("cauldron.bubble_timer", this.bubbleTimer);
        tag.method_10566("cauldron.particle_type", (class_2520)class_2398.field_25125.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.particleType).result().get());
        super.method_11007(tag, registries);
    }

    @Deprecated
    public Pair<class_9062, class_1799> insert(class_1799 itemStack) {
        Integer potionQuantity = this.getFillLevel();
        if (itemStack.method_57826(class_9334.field_49651) && (this.contents.isPotion() || this.contents == CauldronContents.EMPTY) && potionQuantity < 3 && !itemStack.method_31573(CauldronModTags.CANNOT_FILL_CAULDRON)) {
            class_1844 insertedPotion = (class_1844)itemStack.method_57824(class_9334.field_49651);
            assert (insertedPotion != null);
            Optional<class_6880<class_1842>> currentPotion = this.contents.potion();
            if (currentPotion.isEmpty()) {
                this.contents = new CauldronContents(insertedPotion);
                this.setFillLevel(1);
                return new Pair((Object)class_9062.field_47728, (Object)class_1802.field_8469.method_7854());
            }
            if (insertedPotion.method_57401(currentPotion.get())) {
                this.setFillLevel(potionQuantity + 1);
                return new Pair((Object)class_9062.field_47728, (Object)class_1802.field_8469.method_7854());
            }
        }
        if (this.reagent.method_7960()) {
            this.reagent = itemStack;
            if (this.getFillLevel() > 0 && this.method_10997().method_8608()) {
                class_2400 particle = class_2398.field_11202;
                if (this.contents.is("honey")) {
                    particle = class_2398.field_20536;
                } else if (this.contents.is("lava")) {
                    particle = class_2398.field_18305;
                }
                for (int i = 0; i < 20; ++i) {
                    Random random = new Random();
                    double d = random.nextDouble();
                    double e = random.nextDouble();
                    this.method_10997().method_8406((class_2394)particle, (double)this.method_11016().method_10263() + d, (double)((float)this.method_11016().method_10264() + 1.0f), (double)this.method_11016().method_10260() + e, 0.05, 0.25, 0.05);
                }
                this.progress = 0;
            }
            return new Pair((Object)class_9062.field_47728, (Object)class_1799.field_8037);
        }
        return new Pair((Object)class_9062.field_47731, (Object)class_1799.field_8037);
    }

    public void brew(boolean cauldronHeated) {
        BrewingRecipeInput input = new BrewingRecipeInput(this.reagent, this.contents, cauldronHeated);
        if (!this.field_11863.method_8608()) {
            class_1799 potionItem;
            class_1845 potionBrewing;
            Optional dippingRecipe;
            Optional brewingRecipe = this.field_11863.method_8433().method_8132(CauldronModRecipes.BREWING.get(), (class_9695)input, this.field_11863);
            if (brewingRecipe.isPresent()) {
                this.contents = ((BrewingRecipe)((class_8786)brewingRecipe.get()).comp_1933()).getResultPotion((class_7225.class_7874)this.field_11863.method_30349());
                this.updateAfterBrewing(class_1799.field_8037, this.contents, ((BrewingRecipe)((class_8786)brewingRecipe.get()).comp_1933()).getParticleType());
            }
            if ((dippingRecipe = this.field_11863.method_8433().method_8132(CauldronModRecipes.DIPPING.get(), (class_9695)input, this.field_11863)).isPresent()) {
                this.updateAfterBrewing(((DippingRecipe)((class_8786)dippingRecipe.get()).comp_1933()).method_8110((class_7225.class_7874)this.field_11863.method_30349()), this.contents, ((DippingRecipe)((class_8786)dippingRecipe.get()).comp_1933()).getParticleType());
                this.setFillLevel(0);
            } else if (this.reagent.method_31573(CauldronModTags.CREATES_SPLASH_POTIONS) && this.contents.isPotion()) {
                this.splashing = true;
                this.lingering = false;
                this.updateAfterBrewing(class_1799.field_8037, this.contents, (class_2394)class_2398.field_11251);
            } else if (this.reagent.method_31573(CauldronModTags.CREATES_LINGERING_POTIONS) && this.contents.isPotion()) {
                this.splashing = false;
                this.lingering = true;
                this.updateAfterBrewing(class_1799.field_8037, this.contents, (class_2394)class_2398.field_11216);
            } else if (((Boolean)CauldronMod.CONFIG.useBrewingStandRecipes.value()).booleanValue() && (potionBrewing = this.field_11863.method_59547()).method_8072(potionItem = CauldronContents.createItemStack(class_1802.field_8574, this.contents), this.reagent)) {
                class_1799 mix = potionBrewing.method_8078(this.reagent, potionItem);
                this.contents = new CauldronContents(Objects.requireNonNullElse((class_1844)mix.method_57353().method_57829(class_9334.field_49651), class_1844.field_49274));
                this.updateAfterBrewing(class_1799.field_8037, this.contents, (class_2394)class_2398.field_11247);
            }
        }
    }

    private void updateAfterBrewing(class_1799 stack, CauldronContents contents, class_2394 particleType) {
        Optional optional;
        this.reagent = stack;
        this.field_11863.method_45447(null, this.method_11016(), CauldronModSoundEvents.BREWS.get(), class_3419.field_15245);
        class_2680 state = this.method_11010();
        int potionQuantity = state.method_28500((class_2769)class_5556.field_27206).orElse(0) + state.method_28500((class_2769)BrewingCauldronBlock.POTION_QUANTITY).orElse(0) + contents.amount();
        if (contents.isPotion() && (optional = class_7923.field_41175.method_17966(contents.id())).isPresent()) {
            state = (class_2680)((class_2680)((class_2248)optional.get()).method_9564().method_47968((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(potionQuantity))).method_47968((class_2769)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)Integer.valueOf(potionQuantity));
        }
        if (potionQuantity > 3) {
            potionQuantity = 3;
        }
        this.field_11863.method_8501(this.method_11016(), (class_2680)((class_2680)((class_2680)state.method_47968((class_2769)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(false))).method_47968((class_2769)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)Integer.valueOf(potionQuantity))).method_47968(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)this.getContentsProperty())));
        this.bubbleTimer = 20;
        this.particleType = particleType;
    }

    public class_1799 retrieve() {
        return this.reagent.method_51164();
    }

    public class_1799 getItem() {
        return this.reagent;
    }

    public Integer getFillLevel() {
        Integer value = (Integer)this.method_11010().method_11654((class_2769)BrewingCauldronBlock.POTION_QUANTITY);
        return value;
    }

    public void setFillLevel(int value) {
        BrewingCauldronBlock.setFillLevel(this.method_11010(), this.method_10997(), this.method_11016(), value);
    }

    public int getPotionColour() {
        return this.contents.getColor();
    }

    public List<class_2561> getForWaila(class_2680 state) {
        ArrayList<class_2561> iTooltip = new ArrayList<class_2561>();
        if (this.getContents() != CauldronContents.EMPTY) {
            iTooltip.add((class_2561)class_2561.method_43469((String)"gui.toil_and_trouble.doses", (Object[])new Object[]{state.method_11654((class_2769)BrewingCauldronBlock.POTION_QUANTITY)}).method_27692(class_124.field_1064));
            if (this.getContents().isPotion()) {
                class_1792 item = class_1802.field_8574;
                if (this.isPotionSplash()) {
                    item = class_1802.field_8436;
                } else if (this.isPotionLingering()) {
                    item = class_1802.field_8150;
                }
                iTooltip.add(CauldronContents.createItemStack(item, this.getContents()).method_7964());
                if (class_437.method_25442()) {
                    class_1844.method_8065(this.getContents().getAllEffects(), iTooltip::add, (float)0.0f, (float)0.0f);
                }
            } else {
                iTooltip.add((class_2561)class_2561.method_48321((String)this.getContents().id().method_42093("cauldron"), (String)WordUtils.capitalize((String)this.getContents().id().method_12832().replace("_", " "))));
            }
            if (!this.getItem().method_7960()) {
                iTooltip.add((class_2561)class_2561.method_43473());
            }
        }
        return iTooltip;
    }

    public CauldronContents getContents() {
        return this.contents;
    }

    public void setContents(CauldronContents contents) {
        this.contents = contents;
    }

    public boolean isPotionWater() {
        if (this.contents.potion().isPresent()) {
            return Objects.equals(this.contents.potion().get(), class_1847.field_8991);
        }
        return false;
    }

    public boolean isPotionSplash() {
        if (this.contents.isPotion()) {
            return this.splashing;
        }
        return false;
    }

    public boolean isPotionLingering() {
        if (this.contents.isPotion()) {
            return this.lingering;
        }
        return false;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, class_2586 blockEntity) {
        if (blockEntity instanceof CauldronBlockEntity) {
            class_2680 newState;
            boolean cauldronHeated;
            boolean cauldronCanBrew;
            CauldronBlockEntity cauldronBlockEntity = (CauldronBlockEntity)blockEntity;
            if (cauldronBlockEntity.isBubbling()) {
                double d = (double)pos.method_10263() + level.field_9229.method_43058();
                double e = pos.method_10264() + 1;
                double f = (double)pos.method_10260() + level.field_9229.method_43058();
                if (cauldronBlockEntity.getContents() != CauldronContents.EMPTY) {
                    ArrayList effects = new ArrayList();
                    cauldronBlockEntity.getContents().getAllEffects().forEach(effects::add);
                    if (cauldronBlockEntity.particleType != class_2398.field_11247) {
                        level.method_8406(cauldronBlockEntity.particleType, d, e, f, 0.01, 0.05, 0.01);
                    } else if (!effects.isEmpty()) {
                        for (class_1293 effect : effects) {
                            level.method_8406(effect.method_58148(), d, e, f, 0.01, 0.05, 0.01);
                        }
                    } else if (cauldronBlockEntity.pop) {
                        level.method_8406((class_2394)class_2398.field_11241, d, e, f, 0.01, 0.05, 0.01);
                    } else {
                        level.method_8406((class_2394)class_2398.field_11247, d, e, f, 0.01, 0.05, 0.01);
                    }
                }
                cauldronBlockEntity.pop = !cauldronBlockEntity.pop;
                --cauldronBlockEntity.bubbleTimer;
            }
            boolean bl = cauldronCanBrew = (cauldronHeated = level.method_8320(pos.method_10074()).method_26164(CauldronModTags.HEATS_CAULDRONS)) || (Boolean)CauldronMod.CONFIG.requiresHeat.value() == false;
            if (cauldronCanBrew && !cauldronBlockEntity.reagent.method_7960()) {
                int maxProgress = cauldronBlockEntity.maxProgress;
                if (cauldronHeated) {
                    maxProgress = (int)((float)maxProgress * ((Float)CauldronMod.CONFIG.heatAmplification.value()).floatValue());
                }
                if (cauldronBlockEntity.progress > maxProgress) {
                    cauldronBlockEntity.brew(cauldronHeated);
                    cauldronBlockEntity.progress = 0;
                } else {
                    ++cauldronBlockEntity.progress;
                    if (!((Boolean)blockState.method_11654((class_2769)BrewingCauldronBlock.BREWING)).booleanValue()) {
                        level.method_8501(pos, (class_2680)blockState.method_11657((class_2769)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
            if ((newState = level.method_8320(pos)).method_27852(CauldronModBlocks.BREWING_CAULDRON.get())) {
                if (cauldronBlockEntity.reagent.method_7960()) {
                    if (cauldronBlockEntity.getFillLevel().equals(0)) {
                        newState = class_2246.field_10593.method_9564();
                    } else if (((Boolean)blockState.method_11654((class_2769)BrewingCauldronBlock.BREWING)).booleanValue()) {
                        newState = (class_2680)newState.method_47968((class_2769)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(false));
                    }
                }
                if (newState.method_28500((class_2769)BrewingCauldronBlock.POTION_QUANTITY).orElse(0).equals(0)) {
                    cauldronBlockEntity.contents = CauldronContents.EMPTY;
                    cauldronBlockEntity.splashing = false;
                    cauldronBlockEntity.lingering = false;
                }
                newState = (class_2680)((class_2680)newState.method_47968((class_2769)BrewingCauldronBlock.HEATED, (Comparable)Boolean.valueOf(cauldronHeated))).method_47968(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)cauldronBlockEntity.getContentsProperty()));
            }
            if (newState != blockState) {
                level.method_8501(pos, newState);
            }
        }
    }

    private BrewingCauldronBlock.Contents getContentsProperty() {
        if (this.getContents().is((class_6880<class_1842>)class_1847.field_8991)) {
            return BrewingCauldronBlock.Contents.WATER;
        }
        if (this.getContents().potion().isPresent()) {
            return BrewingCauldronBlock.Contents.POTION;
        }
        if (this.getContents().is("honey")) {
            return BrewingCauldronBlock.Contents.HONEY;
        }
        if (this.getContents().is(class_2960.method_60655((String)"chorus_honey", (String)"chorus_honey"))) {
            return BrewingCauldronBlock.Contents.CHORUS_HONEY;
        }
        if (this.getContents().is("lava")) {
            return BrewingCauldronBlock.Contents.LAVA;
        }
        if (this.getContents().is(class_2960.method_60656((String)"air"))) {
            return BrewingCauldronBlock.Contents.EMPTY;
        }
        return BrewingCauldronBlock.Contents.POTION;
    }

    private boolean isBubbling() {
        return this.bubbleTimer > 0;
    }

    public int[] method_5494(class_2350 side) {
        return new int[1];
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.reagent.method_7960();
    }

    public class_1799 method_5438(int slot) {
        return this.reagent;
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.reagent.method_51164();
    }

    public class_1799 method_5441(int slot) {
        return this.reagent.method_51164();
    }

    public void method_5447(int slot, class_1799 stack) {
        this.reagent = stack;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.reagent.method_51164();
    }
}

