/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.core;

import cc.cassian.cauldrons.CauldronMod;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;

public record CauldronContents(class_2960 id, Optional<class_6880<class_1842>> potion, Optional<Integer> customColor, List<class_1293> customEffects, Integer amount, Optional<String> customName) {
    public static final CauldronContents EMPTY = new CauldronContents(class_2960.method_60656((String)"air"), Optional.empty(), Optional.empty(), List.of(), 0, Optional.empty());
    private static final Codec<CauldronContents> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("id", (Object)class_2960.method_60656((String)"potion")).forGetter(CauldronContents::id), (App)class_1842.field_51947.optionalFieldOf("potion").forGetter(CauldronContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(CauldronContents::customColor), (App)class_1293.field_48821.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(CauldronContents::customEffects), (App)Codec.INT.optionalFieldOf("amount", (Object)3).forGetter(CauldronContents::amount), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(CauldronContents::customName)).apply((Applicative)instance, CauldronContents::new));
    public static final Codec<CauldronContents> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)class_1842.field_51947, CauldronContents::new);
    public static final class_9139<class_9129, CauldronContents> STREAM_CODEC = class_9139.method_58025((class_9139)class_2960.field_48267, CauldronContents::id, (class_9139)class_1842.field_51948.method_56433(class_9135::method_56382), CauldronContents::potion, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), CauldronContents::customColor, (class_9139)class_1293.field_49207.method_56433(class_9135.method_56363()), CauldronContents::customEffects, (class_9139)class_9135.field_49675, CauldronContents::amount, (class_9139)class_9135.field_48554.method_56433(class_9135::method_56382), CauldronContents::customName, CauldronContents::new);

    public CauldronContents(class_6880<class_1842> potion) {
        this(class_2960.method_60656((String)"potion"), Optional.of(potion), Optional.empty(), List.of(), 3, Optional.empty());
    }

    public CauldronContents(class_1844 potion) {
        this(class_2960.method_60656((String)"potion"), potion.comp_2378(), potion.comp_2379(), potion.comp_2380(), 3, Optional.empty());
    }

    public CauldronContents(class_2960 potion) {
        this(potion, Optional.empty(), Optional.empty(), List.of(), 3, Optional.empty());
    }

    public CauldronContents(String potion) {
        this(CauldronMod.of(potion));
    }

    public static class_1799 createItemStack(class_1792 item, CauldronContents potion) {
        class_1799 stack = item.method_7854();
        stack.method_57379(class_9334.field_49651, (Object)potion.toPotionContents());
        potion.customName.ifPresent(s -> stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)(item.method_7876() + ".effect." + s))));
        return stack;
    }

    public boolean is(class_6880<class_1842> potion) {
        return this.potion.isPresent() && this.potion.get().method_55838(potion) && this.customEffects.isEmpty();
    }

    public boolean is(class_2960 potion) {
        return potion.equals((Object)this.id());
    }

    public class_1844 toPotionContents() {
        return new class_1844(this.potion, this.customColor, this.customEffects);
    }

    public int getColor() {
        return this.customColor.orElseGet(() -> {
            if (this.isPotion()) {
                return class_1844.method_8055(this.getAllEffects());
            }
            return -1;
        });
    }

    public Iterable<class_1293> getAllEffects() {
        return this.potion.map(potionHolder -> this.customEffects.isEmpty() ? ((class_1842)potionHolder.comp_349()).method_8049() : Iterables.concat((Iterable)((class_1842)potionHolder.comp_349()).method_8049(), this.customEffects)).orElse(this.customEffects);
    }

    public boolean test(CauldronContents testedContents) {
        if (this.potion.isPresent() && testedContents.potion.isPresent()) {
            return this.is(testedContents.potion.get());
        }
        return this.is(testedContents.id);
    }

    public boolean isPotion() {
        return this.is(class_2960.method_60656((String)"potion"));
    }

    public boolean is(String name) {
        return this.is(CauldronMod.of(name));
    }
}

