/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.blocks;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.blocks.entity.CauldronBlockEntity;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModEvents;
import cc.cassian.cauldrons.core.CauldronModHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BrewingCauldronBlock
extends CauldronBlock
implements EntityBlock {
    public static final IntegerProperty POTION_QUANTITY = IntegerProperty.create((String)"potion_quantity", (int)0, (int)3);
    public static final BooleanProperty BREWING = BooleanProperty.create((String)"brewing");
    public static final BooleanProperty HEATED = BooleanProperty.create((String)"heated");
    public static final EnumProperty<Contents> CONTENTS = EnumProperty.create((String)"contents", Contents.class, (Enum[])new Contents[]{Contents.POTION, Contents.HONEY, Contents.WATER, Contents.EMPTY, Contents.LAVA, Contents.CHORUS_HONEY});

    public BrewingCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POTION_QUANTITY, (Comparable)Integer.valueOf(0))).setValue((Property)BREWING, (Comparable)Boolean.valueOf(false))).setValue((Property)HEATED, (Comparable)Boolean.valueOf(false))).setValue(CONTENTS, (Comparable)((Object)Contents.EMPTY)));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CauldronBlockEntity::tick;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return CauldronModEvents.insert(itemStack, blockState, level, pos, player, interactionHand, blockHitResult.getDirection());
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        CauldronBlockEntity cauldronBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CauldronBlockEntity && !(cauldronBlockEntity = (CauldronBlockEntity)blockEntity).isEmpty()) {
            CauldronModEvents.addItem(player, null, level, pos, blockHitResult.getDirection(), cauldronBlockEntity.retrieve());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block5: {
            CauldronBlockEntity cauldronBlockEntity;
            block7: {
                block6: {
                    BlockEntity blockEntity;
                    if (level.isClientSide() || !this.isEntityInsideContent(state, pos, entity) || !((blockEntity = level.getBlockEntity(pos)) instanceof CauldronBlockEntity)) break block5;
                    cauldronBlockEntity = (CauldronBlockEntity)blockEntity;
                    if (!(entity instanceof ItemEntity)) break block6;
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (itemEntity.tickCount <= 10) break block6;
                    CauldronModEvents.insert(itemEntity.getItem(), state, level, pos, null, null, null);
                    break block5;
                }
                if (cauldronBlockEntity.getContents() == CauldronContents.EMPTY) break block5;
                if (!cauldronBlockEntity.isPotionWater()) break block7;
                if (!entity.isOnFire()) break block5;
                entity.clearFire();
                if (!CauldronModHelpers.canInteract(level, pos, entity)) break block5;
                BrewingCauldronBlock.lowerFillLevel(state, level, pos);
                break block5;
            }
            if (cauldronBlockEntity.getContents().is("lava")) {
                entity.lavaHurt();
            } else if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (((Boolean)CauldronMod.CONFIG.cauldronsApplyEffects.value()).booleanValue() && livingEntity.isAffectedByPotions()) {
                    for (MobEffectInstance effect : cauldronBlockEntity.getContents().getAllEffects()) {
                        livingEntity.addEffect(new MobEffectInstance(effect.getEffect(), 1, effect.getAmplifier(), true, true));
                    }
                }
            }
        }
    }

    protected double getContentHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.getValue((Property)POTION_QUANTITY)).intValue() * 3.0) / 16.0;
    }

    public static void lowerFillLevel(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)POTION_QUANTITY) - 1;
        BrewingCauldronBlock.setFillLevel(state, level, pos, i);
    }

    public static void raiseFillLevel(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)POTION_QUANTITY) - 1;
        BrewingCauldronBlock.setFillLevel(state, level, pos, i);
    }

    public static void setFillLevel(BlockState state, Level level, BlockPos pos, int i) {
        if (i > 3 || i < -1) {
            return;
        }
        BlockState blockState = (BlockState)state.setValue((Property)POTION_QUANTITY, (Comparable)Integer.valueOf(i));
        level.setBlockAndUpdate(pos, blockState);
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (CauldronBlock.shouldHandlePrecipitation((Level)level, (Biome.Precipitation)precipitation) && (Integer)state.getValue((Property)POTION_QUANTITY) != 3) {
            CauldronBlockEntity cauldronBlockEntity;
            BlockEntity blockEntity;
            if ((Integer)state.getValue((Property)POTION_QUANTITY) == 0) {
                if (precipitation == Biome.Precipitation.RAIN) {
                    BlockState blockState = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1));
                    level.setBlockAndUpdate(pos, blockState);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
                } else if (precipitation == Biome.Precipitation.SNOW) {
                    BlockState blockState = (BlockState)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1));
                    level.setBlockAndUpdate(pos, blockState);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockState));
                }
            } else if (precipitation == Biome.Precipitation.RAIN && (blockEntity = level.getBlockEntity(pos)) instanceof CauldronBlockEntity && (cauldronBlockEntity = (CauldronBlockEntity)blockEntity).isPotionWater()) {
                BrewingCauldronBlock.raiseFillLevel(state, level, pos);
            }
        }
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)Blocks.CAULDRON);
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)POTION_QUANTITY) == 3;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)POTION_QUANTITY);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POTION_QUANTITY, BREWING, HEATED, CONTENTS});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CauldronBlockEntity) {
                CauldronBlockEntity cauldronBlockEntity = (CauldronBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)cauldronBlockEntity.getItem());
                }
                super.onRemove(state, level, pos, newState, movedByPiston);
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            } else {
                super.onRemove(state, level, pos, newState, movedByPiston);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CauldronBlockEntity(blockPos, blockState);
    }

    public static enum Contents implements StringRepresentable
    {
        EMPTY("empty"),
        WATER("water"),
        LAVA("lava"),
        POTION("potion"),
        HONEY("honey"),
        CHORUS_HONEY("chorus_honey");

        private final String name;

        private Contents(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

