/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.cauldrons.blocks.entity;

import cc.cassian.cauldrons.CauldronMod;
import cc.cassian.cauldrons.blocks.BrewingCauldronBlock;
import cc.cassian.cauldrons.core.CauldronContents;
import cc.cassian.cauldrons.core.CauldronModRecipes;
import cc.cassian.cauldrons.core.CauldronModTags;
import cc.cassian.cauldrons.recipe.BrewingRecipe;
import cc.cassian.cauldrons.recipe.BrewingRecipeInput;
import cc.cassian.cauldrons.recipe.DippingRecipe;
import cc.cassian.cauldrons.registry.CauldronModBlockEntityTypes;
import cc.cassian.cauldrons.registry.CauldronModBlocks;
import cc.cassian.cauldrons.registry.CauldronModSoundEvents;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class CauldronBlockEntity
extends BlockEntity
implements WorldlyContainer {
    protected CauldronContents contents = CauldronContents.EMPTY;
    protected boolean splashing = false;
    protected boolean lingering = false;
    private int progress;
    private int maxProgress;
    private int bubbleTimer;
    private boolean pop;
    private ItemStack reagent;
    private ParticleOptions particleType;

    public CauldronBlockEntity(BlockPos pos, BlockState state, CauldronContents contents) {
        super(CauldronModBlockEntityTypes.CAULDRON_BLOCK_ENTITY.get(), pos, state);
        this.maxProgress = (Integer)CauldronMod.CONFIG.brewingTime.value() * 20;
        this.bubbleTimer = 0;
        this.pop = false;
        this.reagent = ItemStack.EMPTY;
        this.particleType = ParticleTypes.BUBBLE;
        this.contents = contents;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public CauldronBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(CauldronModBlockEntityTypes.CAULDRON_BLOCK_ENTITY.get(), blockPos, blockState);
        this.maxProgress = (Integer)CauldronMod.CONFIG.brewingTime.value() * 20;
        this.bubbleTimer = 0;
        this.pop = false;
        this.reagent = ItemStack.EMPTY;
        this.particleType = ParticleTypes.BUBBLE;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Tag inventory = tag.get("cauldron.inventory");
        this.reagent = inventory != null ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)inventory).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.progress = tag.getInt("cauldron.progress");
        this.maxProgress = tag.getInt("cauldron.max_progress");
        this.contents = (CauldronContents)((com.mojang.datafixers.util.Pair)CauldronContents.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("cauldron.potion")).result().get()).getFirst();
        this.splashing = tag.getBoolean("cauldron.splashing");
        this.lingering = tag.getBoolean("cauldron.lingering");
        this.bubbleTimer = tag.getInt("cauldron.bubble_timer");
        if (tag.contains("cauldron.particle_type")) {
            this.particleType = (ParticleOptions)((com.mojang.datafixers.util.Pair)ParticleTypes.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("cauldron.particle_type")).result().get()).getFirst();
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (!this.reagent.isEmpty()) {
            tag.put("cauldron.inventory", this.reagent.save(registries));
        }
        tag.putInt("cauldron.progress", this.progress);
        tag.putInt("cauldron.max_progress", this.maxProgress);
        tag.put("cauldron.potion", (Tag)CauldronContents.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.contents).result().get());
        tag.putBoolean("cauldron.splashing", this.splashing);
        tag.putBoolean("cauldron.lingering", this.lingering);
        tag.putInt("cauldron.bubble_timer", this.bubbleTimer);
        tag.put("cauldron.particle_type", (Tag)ParticleTypes.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.particleType).result().get());
        super.saveAdditional(tag, registries);
    }

    @Deprecated
    public Pair<ItemInteractionResult, ItemStack> insert(ItemStack itemStack) {
        Integer potionQuantity = this.getFillLevel();
        if (itemStack.has(DataComponents.POTION_CONTENTS) && (this.contents.isPotion() || this.contents == CauldronContents.EMPTY) && potionQuantity < 3 && !itemStack.is(CauldronModTags.CANNOT_FILL_CAULDRON)) {
            PotionContents insertedPotion = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
            assert (insertedPotion != null);
            Optional<Holder<Potion>> currentPotion = this.contents.potion();
            if (currentPotion.isEmpty()) {
                this.contents = new CauldronContents(insertedPotion);
                this.setFillLevel(1);
                return new Pair((Object)ItemInteractionResult.SUCCESS, (Object)Items.GLASS_BOTTLE.getDefaultInstance());
            }
            if (insertedPotion.is(currentPotion.get())) {
                this.setFillLevel(potionQuantity + 1);
                return new Pair((Object)ItemInteractionResult.SUCCESS, (Object)Items.GLASS_BOTTLE.getDefaultInstance());
            }
        }
        if (this.reagent.isEmpty()) {
            this.reagent = itemStack;
            if (this.getFillLevel() > 0 && this.getLevel().isClientSide()) {
                SimpleParticleType particle = ParticleTypes.SPLASH;
                if (this.contents.is("honey")) {
                    particle = ParticleTypes.LANDING_HONEY;
                } else if (this.contents.is("lava")) {
                    particle = ParticleTypes.LANDING_LAVA;
                }
                for (int i = 0; i < 20; ++i) {
                    Random random = new Random();
                    double d = random.nextDouble();
                    double e = random.nextDouble();
                    this.getLevel().addParticle((ParticleOptions)particle, (double)this.getBlockPos().getX() + d, (double)((float)this.getBlockPos().getY() + 1.0f), (double)this.getBlockPos().getZ() + e, 0.05, 0.25, 0.05);
                }
                this.progress = 0;
            }
            return new Pair((Object)ItemInteractionResult.SUCCESS, (Object)ItemStack.EMPTY);
        }
        return new Pair((Object)ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION, (Object)ItemStack.EMPTY);
    }

    public void brew(boolean cauldronHeated) {
        BrewingRecipeInput input = new BrewingRecipeInput(this.reagent, this.contents, cauldronHeated);
        if (!this.level.isClientSide()) {
            ItemStack potionItem;
            PotionBrewing potionBrewing;
            Optional dippingRecipe;
            Optional brewingRecipe = this.level.getRecipeManager().getRecipeFor(CauldronModRecipes.BREWING.get(), (RecipeInput)input, this.level);
            if (brewingRecipe.isPresent()) {
                this.contents = ((BrewingRecipe)((RecipeHolder)brewingRecipe.get()).value()).getResultPotion((HolderLookup.Provider)this.level.registryAccess());
                this.updateAfterBrewing(ItemStack.EMPTY, this.contents, ((BrewingRecipe)((RecipeHolder)brewingRecipe.get()).value()).getParticleType());
            }
            if ((dippingRecipe = this.level.getRecipeManager().getRecipeFor(CauldronModRecipes.DIPPING.get(), (RecipeInput)input, this.level)).isPresent()) {
                this.updateAfterBrewing(((DippingRecipe)((RecipeHolder)dippingRecipe.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()), this.contents, ((DippingRecipe)((RecipeHolder)dippingRecipe.get()).value()).getParticleType());
                this.setFillLevel(0);
            } else if (this.reagent.is(CauldronModTags.CREATES_SPLASH_POTIONS) && this.contents.isPotion()) {
                this.splashing = true;
                this.lingering = false;
                this.updateAfterBrewing(ItemStack.EMPTY, this.contents, (ParticleOptions)ParticleTypes.SMOKE);
            } else if (this.reagent.is(CauldronModTags.CREATES_LINGERING_POTIONS) && this.contents.isPotion()) {
                this.splashing = false;
                this.lingering = true;
                this.updateAfterBrewing(ItemStack.EMPTY, this.contents, (ParticleOptions)ParticleTypes.DRAGON_BREATH);
            } else if (((Boolean)CauldronMod.CONFIG.useBrewingStandRecipes.value()).booleanValue() && (potionBrewing = this.level.potionBrewing()).hasMix(potionItem = CauldronContents.createItemStack(Items.POTION, this.contents), this.reagent)) {
                ItemStack mix = potionBrewing.mix(this.reagent, potionItem);
                this.contents = new CauldronContents(Objects.requireNonNullElse((PotionContents)mix.getComponents().get(DataComponents.POTION_CONTENTS), PotionContents.EMPTY));
                this.updateAfterBrewing(ItemStack.EMPTY, this.contents, (ParticleOptions)ParticleTypes.BUBBLE);
            }
        }
    }

    private void updateAfterBrewing(ItemStack stack, CauldronContents contents, ParticleOptions particleType) {
        Optional optional;
        this.reagent = stack;
        this.level.playSound(null, this.getBlockPos(), CauldronModSoundEvents.BREWS.get(), SoundSource.BLOCKS);
        BlockState state = this.getBlockState();
        int potionQuantity = state.getOptionalValue((Property)LayeredCauldronBlock.LEVEL).orElse(0) + state.getOptionalValue((Property)BrewingCauldronBlock.POTION_QUANTITY).orElse(0) + contents.amount();
        if (contents.isPotion() && (optional = BuiltInRegistries.BLOCK.getOptional(contents.id())).isPresent()) {
            state = (BlockState)((BlockState)((Block)optional.get()).defaultBlockState().trySetValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(potionQuantity))).trySetValue((Property)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)Integer.valueOf(potionQuantity));
        }
        if (potionQuantity > 3) {
            potionQuantity = 3;
        }
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)((BlockState)state.trySetValue((Property)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(false))).trySetValue((Property)BrewingCauldronBlock.POTION_QUANTITY, (Comparable)Integer.valueOf(potionQuantity))).trySetValue(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)this.getContentsProperty())));
        this.bubbleTimer = 20;
        this.particleType = particleType;
    }

    public ItemStack retrieve() {
        return this.reagent.copyAndClear();
    }

    public ItemStack getItem() {
        return this.reagent;
    }

    public Integer getFillLevel() {
        Integer value = (Integer)this.getBlockState().getValue((Property)BrewingCauldronBlock.POTION_QUANTITY);
        return value;
    }

    public void setFillLevel(int value) {
        BrewingCauldronBlock.setFillLevel(this.getBlockState(), this.getLevel(), this.getBlockPos(), value);
    }

    public int getPotionColour() {
        return this.contents.getColor();
    }

    public List<Component> getForWaila(BlockState state) {
        ArrayList<Component> iTooltip = new ArrayList<Component>();
        if (this.getContents() != CauldronContents.EMPTY) {
            iTooltip.add((Component)Component.translatable((String)"gui.toil_and_trouble.doses", (Object[])new Object[]{state.getValue((Property)BrewingCauldronBlock.POTION_QUANTITY)}).withStyle(ChatFormatting.DARK_PURPLE));
            if (this.getContents().isPotion()) {
                Item item = Items.POTION;
                if (this.isPotionSplash()) {
                    item = Items.SPLASH_POTION;
                } else if (this.isPotionLingering()) {
                    item = Items.LINGERING_POTION;
                }
                iTooltip.add(CauldronContents.createItemStack(item, this.getContents()).getHoverName());
                if (Screen.hasShiftDown()) {
                    PotionContents.addPotionTooltip(this.getContents().getAllEffects(), iTooltip::add, (float)0.0f, (float)0.0f);
                }
            } else {
                iTooltip.add((Component)Component.translatableWithFallback((String)this.getContents().id().toLanguageKey("cauldron"), (String)WordUtils.capitalize((String)this.getContents().id().getPath().replace("_", " "))));
            }
            if (!this.getItem().isEmpty()) {
                iTooltip.add((Component)Component.empty());
            }
        }
        return iTooltip;
    }

    public CauldronContents getContents() {
        return this.contents;
    }

    public void setContents(CauldronContents contents) {
        this.contents = contents;
    }

    public boolean isPotionWater() {
        if (this.contents.potion().isPresent()) {
            return Objects.equals(this.contents.potion().get(), Potions.WATER);
        }
        return false;
    }

    public boolean isPotionSplash() {
        if (this.contents.isPotion()) {
            return this.splashing;
        }
        return false;
    }

    public boolean isPotionLingering() {
        if (this.contents.isPotion()) {
            return this.lingering;
        }
        return false;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof CauldronBlockEntity) {
            BlockState newState;
            boolean cauldronHeated;
            boolean cauldronCanBrew;
            CauldronBlockEntity cauldronBlockEntity = (CauldronBlockEntity)blockEntity;
            if (cauldronBlockEntity.isBubbling()) {
                double d = (double)pos.getX() + level.random.nextDouble();
                double e = pos.getY() + 1;
                double f = (double)pos.getZ() + level.random.nextDouble();
                if (cauldronBlockEntity.getContents() != CauldronContents.EMPTY) {
                    ArrayList effects = new ArrayList();
                    cauldronBlockEntity.getContents().getAllEffects().forEach(effects::add);
                    if (cauldronBlockEntity.particleType != ParticleTypes.BUBBLE) {
                        level.addParticle(cauldronBlockEntity.particleType, d, e, f, 0.01, 0.05, 0.01);
                    } else if (!effects.isEmpty()) {
                        for (MobEffectInstance effect : effects) {
                            level.addParticle(effect.getParticleOptions(), d, e, f, 0.01, 0.05, 0.01);
                        }
                    } else if (cauldronBlockEntity.pop) {
                        level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, d, e, f, 0.01, 0.05, 0.01);
                    } else {
                        level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d, e, f, 0.01, 0.05, 0.01);
                    }
                }
                cauldronBlockEntity.pop = !cauldronBlockEntity.pop;
                --cauldronBlockEntity.bubbleTimer;
            }
            boolean bl = cauldronCanBrew = (cauldronHeated = level.getBlockState(pos.below()).is(CauldronModTags.HEATS_CAULDRONS)) || (Boolean)CauldronMod.CONFIG.requiresHeat.value() == false;
            if (cauldronCanBrew && !cauldronBlockEntity.reagent.isEmpty()) {
                int maxProgress = cauldronBlockEntity.maxProgress;
                if (cauldronHeated) {
                    maxProgress = (int)((float)maxProgress * ((Float)CauldronMod.CONFIG.heatAmplification.value()).floatValue());
                }
                if (cauldronBlockEntity.progress > maxProgress) {
                    cauldronBlockEntity.brew(cauldronHeated);
                    cauldronBlockEntity.progress = 0;
                } else {
                    ++cauldronBlockEntity.progress;
                    if (!((Boolean)blockState.getValue((Property)BrewingCauldronBlock.BREWING)).booleanValue()) {
                        level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
            if ((newState = level.getBlockState(pos)).is(CauldronModBlocks.BREWING_CAULDRON.get())) {
                if (cauldronBlockEntity.reagent.isEmpty()) {
                    if (cauldronBlockEntity.getFillLevel().equals(0)) {
                        newState = Blocks.CAULDRON.defaultBlockState();
                    } else if (((Boolean)blockState.getValue((Property)BrewingCauldronBlock.BREWING)).booleanValue()) {
                        newState = (BlockState)newState.trySetValue((Property)BrewingCauldronBlock.BREWING, (Comparable)Boolean.valueOf(false));
                    }
                }
                if (newState.getOptionalValue((Property)BrewingCauldronBlock.POTION_QUANTITY).orElse(0).equals(0)) {
                    cauldronBlockEntity.contents = CauldronContents.EMPTY;
                    cauldronBlockEntity.splashing = false;
                    cauldronBlockEntity.lingering = false;
                }
                newState = (BlockState)((BlockState)newState.trySetValue((Property)BrewingCauldronBlock.HEATED, (Comparable)Boolean.valueOf(cauldronHeated))).trySetValue(BrewingCauldronBlock.CONTENTS, (Comparable)((Object)cauldronBlockEntity.getContentsProperty()));
            }
            if (newState != blockState) {
                level.setBlockAndUpdate(pos, newState);
            }
        }
    }

    private BrewingCauldronBlock.Contents getContentsProperty() {
        if (this.getContents().is((Holder<Potion>)Potions.WATER)) {
            return BrewingCauldronBlock.Contents.WATER;
        }
        if (this.getContents().potion().isPresent()) {
            return BrewingCauldronBlock.Contents.POTION;
        }
        if (this.getContents().is("honey")) {
            return BrewingCauldronBlock.Contents.HONEY;
        }
        if (this.getContents().is(ResourceLocation.fromNamespaceAndPath((String)"chorus_honey", (String)"chorus_honey"))) {
            return BrewingCauldronBlock.Contents.CHORUS_HONEY;
        }
        if (this.getContents().is("lava")) {
            return BrewingCauldronBlock.Contents.LAVA;
        }
        if (this.getContents().is(ResourceLocation.withDefaultNamespace((String)"air"))) {
            return BrewingCauldronBlock.Contents.EMPTY;
        }
        return BrewingCauldronBlock.Contents.POTION;
    }

    private boolean isBubbling() {
        return this.bubbleTimer > 0;
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[1];
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.reagent.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.reagent;
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.reagent.copyAndClear();
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.reagent.copyAndClear();
    }

    public void setItem(int slot, ItemStack stack) {
        this.reagent = stack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.reagent.copyAndClear();
    }
}

